﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Text;

public partial class system_person : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        #region 过期和权限

        PageFunc.IfSystemLogin(this.Page);

        #endregion
        if (IsPostBack)
            return;

        string account = Session["Account1"].ToString();

        StringBuilder strSql = new StringBuilder();
        strSql.Append("select * from NT_Member ");
        strSql.Append(" where Account=@Account");
        OleDbParameter[] parameters = { new OleDbParameter("@Account", OleDbType.VarChar) };
        parameters[0].Value = account;

        OleDbDataReader odr = DbHelperOleDb.ExecuteDataReader(CommandType.Text, strSql.ToString(), parameters);
        if (odr.HasRows)
        {
            while (odr.Read())
            {
                this.lab_Account.Text = odr["Account"].ToString();
                this.txt_Name.Text = odr["Name"].ToString();
                if (odr["Sex"].ToString() == "男")
                {
                    this.rb_Men.Checked = true;
                }
                else
                {
                    this.rb_Women.Checked = true;
                }
                this.ddl_Identity.SelectedValue = odr["Identity"].ToString();
                this.txt_Grade.Text = odr["Grade"].ToString();
                this.txt_Number.Text = odr["Number"].ToString();
                this.txt_Teacher.Text = odr["Teacher"].ToString();
            }
        }
        odr.Close();
    }

    //修改
    protected void Button1_Click(object sender, EventArgs e)
    {

        StringBuilder strSql = new StringBuilder();
        strSql.Append("update NT_Member set ");
        strSql.Append("[Name]=@Name,");
        strSql.Append("[Sex]=@Sex,");
        strSql.Append("[Identity]=@Identity,");
        strSql.Append("[Grade]=@Grade,");
        strSql.Append("[Number]=@Number,");
        strSql.Append("[Teacher]=@Teacher");
        strSql.Append(" where [Account]=@Account");
        OleDbParameter[] parameters = {
                    new OleDbParameter("@Name", OleDbType.VarChar),
					new OleDbParameter("@Sex", OleDbType.VarChar),
                    new OleDbParameter("@Identity", OleDbType.VarChar),
                    new OleDbParameter("@Grade", OleDbType.VarChar),
                    new OleDbParameter("@Number", OleDbType.VarChar),
                    new OleDbParameter("@Teacher", OleDbType.VarChar),
					new OleDbParameter("@Account", OleDbType.VarChar)};
        parameters[0].Value = txt_Name.Text.Trim();
        parameters[1].Value = rb_Men.Checked == true ? "男" : "女";
        parameters[2].Value = ddl_Identity.SelectedValue;
        parameters[3].Value = txt_Grade.Text.Trim();
        parameters[4].Value = txt_Number.Text.Trim();
        parameters[5].Value = txt_Teacher.Text.Trim();
        parameters[6].Value = Session["Account1"].ToString();
        //执行语句
        DbHelperOleDb.ExecuteNonQuery(CommandType.Text, strSql.ToString(), parameters);


        JavaScriptFunc.Alert(this.Page, "修改成功");
    }
}
