﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class system_Video_video : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        #region 过期和权限

        PageFunc.IfSystemLogin(this.Page);

        #endregion
        if (IsPostBack)
            return;

        BindData();
    }


    #region 产品绑定
    /// <summary>
    /// 数据绑定
    /// </summary>
    private void BindData()
    {

        //计算总数的语句的头部
        string sql_CountFirst = string.Empty;
        sql_CountFirst += " select";
        sql_CountFirst += " count(*)";
        sql_CountFirst += " from NT_Data ";
        sql_CountFirst += " where ClassId=370";

        //查询语句的头部
        string sql_SelectFirst = "select ID ,ClassId,Title,sTitle,TitlePicture,Intro,Content,AddTime,FilePath,OrderNum ";
        sql_SelectFirst += " from NT_Data ";
        sql_SelectFirst += " where ClassId=370";
        sql_SelectFirst += " order by OrderNum desc, ID desc";


        DataTable dt_video = WebControlsFunc.GetDataTableByAspNetPager(AspNetPager1, sql_CountFirst, sql_SelectFirst);
        lit_video.Text = "";
        foreach (DataRow dr in dt_video.Rows)
        {
            lit_video.Text += "<li><a href='videodetails.aspx?vid=" + dr["ID"] + "' title='" + dr["Title"] + "'><img src='" + dr["TitlePicture"] + "' /><p>" + FrontFunc.Cutstring(dr["Title"].ToString(), 13) + "</p></a></li>";
        }


    }
    #endregion

    #region 分页事件
    protected void AspNetPager1_PageChanging(object src, Wuqi.Webdiyer.PageChangingEventArgs e)
    {
        this.AspNetPager1.CurrentPageIndex = e.NewPageIndex;
        BindData();
    }
    #endregion
}
