﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class system_Lab_lab : System.Web.UI.Page
{
    protected int typeid = 0;

    protected void Page_Load(object sender, EventArgs e)
    {
        #region 过期和权限

        PageFunc.IfSystemLogin(this.Page);

        #endregion

        if (Request["typeid"] != null&& Request["typeid"].ToString() != "")
        {
            typeid = int.Parse(Request["typeid"].ToString());
        }

        if (IsPostBack)
            return;
        TreeBind();
        BindData();
    }

    #region 绑定类别=================================
    private void TreeBind()
    {
        string strsql = "select * from NT_ClassType where PrantId=309";
        DataTable dt = DbHelperOleDb.ExecuteDataSet(CommandType.Text, strsql, null).Tables[0];

        this.ddlClassType.Items.Clear();
        this.ddlClassType.Items.Add(new ListItem("所有实验室", ""));
        foreach (DataRow dr in dt.Rows)
        {
            string Id = dr["ClassId"].ToString();
            string Title = dr["TypeName"].ToString().Trim();

            this.ddlClassType.Items.Add(new ListItem(Title, Id));
        }
    }
    #endregion

    protected void ddlClassType_SelectedIndexChanged(object sender, EventArgs e)
    {
        Response.Redirect("lab.aspx?typeid=" + ddlClassType.SelectedValue);
    }

    #region 产品绑定
    /// <summary>
    /// 数据绑定
    /// </summary>
    private void BindData()
    {

        //计算总数的语句的头部
        string sql_CountFirst = string.Empty;
        sql_CountFirst += " select";
        sql_CountFirst += " count(*)";
        sql_CountFirst += " from NT_Data ";
        sql_CountFirst += " where 1=1";

        //查询语句的头部
        string sql_SelectFirst = "select ID ,ClassId,Title,sTitle,TitlePicture,Intro,Content,AddTime,FilePath,OrderNum ";
        sql_SelectFirst += " from NT_Data ";
        sql_SelectFirst += " where 1=1";


        if (typeid > 0)
        {
            ddlClassType.SelectedValue = typeid.ToString();
            sql_CountFirst += " and ClassId=" + typeid;
            sql_SelectFirst += " and ClassId=" + typeid;
        }
        else {
            sql_CountFirst += " and ClassId in(299,300,301,302,303,304)";
            sql_SelectFirst += " and ClassId in(299,300,301,302,303,304)";
        }

        sql_SelectFirst += " order by OrderNum desc, ID desc";


        DataTable dt_lab = WebControlsFunc.GetDataTableByAspNetPager(AspNetPager1, sql_CountFirst, sql_SelectFirst);
        lit_lab.Text = "";
        foreach (DataRow dr in dt_lab.Rows)
        {
            lit_lab.Text += "<li>";
            if (MemberFunc.CheckMember(this.Page.Session["Account1"].ToString()))
                lit_lab.Text += "<a href=\"laborder.aspx?lid=" + dr["ID"] + "\" title=\"" + dr["Title"] + "\">";
            else
                lit_lab.Text += "<a href=\"javascript:alert('对不起，您还没有审核通过！');\" title=\"" + dr["Title"] + "\">";
            lit_lab.Text += "<img src=\"" + dr["TitlePicture"] + "\" /><p>" + FrontFunc.Cutstring(dr["Title"].ToString(), 13) + "</p></a></li>";
        }


    }
    #endregion

    #region 分页事件
    protected void AspNetPager1_PageChanging(object src, Wuqi.Webdiyer.PageChangingEventArgs e)
    {
        this.AspNetPager1.CurrentPageIndex = e.NewPageIndex;
        BindData();
    }
    #endregion

}
