﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Text;
using System.Data.OleDb;


public partial class system_Instru_orderadd : System.Web.UI.Page
{
    public DataRow dr;
    public DataTable dt;
    public string date = "";
    protected void Page_Load(object sender, EventArgs e)
    {
        #region 过期和权限

        PageFunc.IfSystemLogin(this.Page);

        #endregion
        //if (IsPostBack)
        //    return;
        if (Request["iid"] != null && Request["iid"].ToString() != "")
        {
            dr = FrontFunc.GetDataByID(Request.QueryString["iid"].ToString());
        }

        
        if (Request["date"] != null && Request.QueryString["date"].ToString()!=null)
        {
            date = Request.QueryString["date"].ToString();
        }

        DataSet ds = DbHelperOleDb.ExecuteDataSet(CommandType.Text, "select * from NT_Instru where DataId="+dr["ID"]+" and StartTime like '" + date + "#' and (Audit=0 or Audit=1) ", null);
        if (ds!=null)
        {
            dt = ds.Tables[0];
        }


        //开始时间
        ListItem[] li1 = { new ListItem("请选择", ""), new ListItem(date + " 8:10"), new ListItem(date + " 9:00"), new ListItem(date + " 10:00"), new ListItem(date + " 10:50"), new ListItem(date + " 11:40"), new ListItem(date + " 13:30"), new ListItem(date + " 14:20"), new ListItem(date + " 15:15"), new ListItem(date + " 16:05"), new ListItem(date + " 18:30"), new ListItem(date + " 19:20"), new ListItem(date + " 20:10") };
        Session["instru_starttime"] = ddl_StartTime.SelectedValue;
        ddl_StartTime.Items.Clear();
        ddl_StartTime.Items.AddRange(li1);
        if (Session["instru_starttime"] != null)
        {
            ddl_StartTime.SelectedValue = Session["instru_starttime"].ToString();
        }

        //结束时间
        List<ListItem> itemlist = new List<ListItem>();
        itemlist.Add(new ListItem("请选择", ""));
        for (int i = 0; i < 5; i++)
        {
            DateTime workday = DateTimeFunc.AddWorkDays(DateTime.Parse(date), i);
            string workdays = workday.ToShortDateString();
            itemlist.Add(new ListItem(workdays + " 8:55"));
            itemlist.Add(new ListItem(workdays + " 9:45"));
            itemlist.Add(new ListItem(workdays + " 10:45"));
            itemlist.Add(new ListItem(workdays + " 11:35"));
            itemlist.Add(new ListItem(workdays + " 12:25"));
            itemlist.Add(new ListItem(workdays + " 14:15"));
            itemlist.Add(new ListItem(workdays + " 15:05"));
            itemlist.Add(new ListItem(workdays + " 16:00"));
            itemlist.Add(new ListItem(workdays + " 16:50"));
            itemlist.Add(new ListItem(workdays + " 19:15"));
            itemlist.Add(new ListItem(workdays + " 20:05"));
            itemlist.Add(new ListItem(workdays + " 20:55"));
        }
        Session["instru_endtime"] = ddl_EndTime.SelectedValue;
        ddl_EndTime.Items.Clear();
        ddl_EndTime.Items.AddRange(itemlist.ToArray());
        if (Session["instru_endtime"] != null)
        {
            ddl_EndTime.SelectedValue = Session["instru_endtime"].ToString();
        }
    }

    //开始时间
    protected void ddl_StartTime_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (ddl_StartTime.SelectedValue != ""&&ddl_EndTime.SelectedValue!="")
        {
            if (DateTime.Parse(ddl_StartTime.SelectedValue) > DateTime.Parse(ddl_EndTime.SelectedValue))
            {
                ddl_StartTime.SelectedIndex = 0;
                JavaScriptFunc.Alert(this.Page, "开始时间不能大于结束时间");
                return;
            }
        }

        foreach (DataRow dr in dt.Rows)
        {
            if (ddl_StartTime.SelectedValue != "")
            {
                if (DateTime.Parse(ddl_StartTime.SelectedValue)>=DateTime.Parse(dr["StartTime"].ToString()) && DateTime.Parse(ddl_StartTime.SelectedValue) <= DateTime.Parse(dr["EndTime"].ToString()))
                {
                    ddl_StartTime.SelectedIndex = 0;
                    JavaScriptFunc.Alert(this.Page, "此段时间被预约或者在审核中");
                    return;
                }
            }
        }
    }

    //结束时间
    protected void ddl_EndTime_SelectedIndexChanged(object sender, EventArgs e)
    {
        
        if (ddl_StartTime.SelectedValue == "")
        {
            ddl_EndTime.SelectedIndex = 0;
            JavaScriptFunc.Alert(this.Page, "请先选择开始时间");
            return;
        }

        if (ddl_EndTime.SelectedValue != "")
        {
            if (DateTime.Parse(ddl_StartTime.SelectedValue) > DateTime.Parse(ddl_EndTime.SelectedValue))
            {
                ddl_EndTime.SelectedIndex = 0;
                JavaScriptFunc.Alert(this.Page, "开始时间不能大于结束时间");
                return;
            }
        }

        foreach (DataRow dr in dt.Rows)
        {
            if (ddl_EndTime.SelectedValue != "")
            {
                if (DateTime.Parse(ddl_EndTime.SelectedValue) >= DateTime.Parse(dr["EndTime"].ToString()) && DateTime.Parse(ddl_EndTime.SelectedValue) <= DateTime.Parse(dr["EndTime"].ToString()))
                {
                    ddl_EndTime.SelectedIndex = 0;
                    JavaScriptFunc.Alert(this.Page, "此段时间被预约或者在审核中");
                    return;
                }
                else if (DateTime.Parse(ddl_StartTime.SelectedValue) <= DateTime.Parse(dr["StartTime"].ToString()) && DateTime.Parse(ddl_EndTime.SelectedValue) >= DateTime.Parse(dr["EndTime"].ToString()))
                {
                    ddl_EndTime.SelectedIndex = 0;
                    JavaScriptFunc.Alert(this.Page, "开始时间到结束时间包含被预约或者在审核中的时间段");
                    return;
                }
            }
        }
        
        
    }

    //提交
    protected void Button1_Click(object sender, EventArgs e)
    {
        StringBuilder strSql = new StringBuilder();
        strSql.Append("insert into NT_Instru(");
        strSql.Append("[MemberId],[DataId],[Type],[Number],[StartTime],[EndTime],[Mark],[Person],[Teacher])");
        strSql.Append(" values (");
        strSql.Append("@MemberId,@DataId,@Type,@Number,@StartTime,@EndTime,@Mark,@Person,@Teacher)");
        OleDbParameter[] parameters = 
            {
                new OleDbParameter("@ClassId", OleDbType.Integer,4),
                new OleDbParameter("@DataId", OleDbType.Integer,4),
                new OleDbParameter("@Type", OleDbType.VarChar),
                new OleDbParameter("@Number", OleDbType.Integer,4),
                new OleDbParameter("@StartTime", OleDbType.Date),
                new OleDbParameter("@EndTime", OleDbType.Date),
                new OleDbParameter("@Mark", OleDbType.VarChar),
                new OleDbParameter("@Person", OleDbType.VarChar),
                new OleDbParameter("@Teacher", OleDbType.VarChar)
            };
        parameters[0].Value = int.Parse(Session["ID1"].ToString());
        parameters[1].Value = int.Parse(dr["ID"].ToString());
        parameters[2].Value = txt_Type.Text.Trim();
        parameters[3].Value = int.Parse(txt_Number.Text.Trim());
        parameters[4].Value = DateTime.Parse(ddl_StartTime.SelectedValue);
        parameters[5].Value = DateTime.Parse(ddl_EndTime.SelectedValue);
        parameters[6].Value = txt_Mark.Text.Trim();
        parameters[7].Value = txt_Person.Text.Trim();
        parameters[8].Value = txt_Teacher.Text.Trim();

        DbHelperOleDb.ExecuteNonQuery(CommandType.Text, strSql.ToString(), parameters);

        txt_Type.Text = "";
        txt_Number.Text = "";
        ddl_StartTime.SelectedValue = "";
        ddl_EndTime.SelectedValue="";
        txt_Mark.Text = "";
        txt_Person.Text = "";
        txt_Teacher.Text = "";

        JavaScriptFunc.Alert(this.Page, "提交成功，待审核");
    }
}
