﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class system_Instru_instruorder : System.Web.UI.Page
{
    public DataRow dr;

    //三个整型数组存放相对月份写有预约的日期
    private int intCurrentMonth, intPreMonth, intNextMonth;
    protected void Page_Load(object sender, EventArgs e)
    {
        #region 过期和权限
        PageFunc.IfSystemLogin(this.Page);
        #endregion
        //if (IsPostBack)
        //    return;

        if (Request["iid"] != null && Request["iid"].ToString() != "")
        {
            dr = FrontFunc.GetDataByID(Request.QueryString["iid"].ToString());
        }
    }


    protected void CalPlan_DayRender(object sender, DayRenderEventArgs e)
    {
        CalendarDay d = ((DayRenderEventArgs)e).Day;
        TableCell c = ((DayRenderEventArgs)e).Cell;

        if (intPreMonth == 0)
        {
            //日历控件初始化时取得的是第一个月并不是当前月，而是前一个月的月份 
            intPreMonth = d.Date.Month;

            intCurrentMonth = intPreMonth + 1;
            if (intCurrentMonth > 12)
                intCurrentMonth = 1;

            intNextMonth = intCurrentMonth + 1;
            if (intNextMonth > 12)
                intNextMonth = 1;
        }

        c.Controls.Clear();//绘制前先清除

        if (d.Date.Month.Equals(intPreMonth))
        {
            c.Controls.Clear();//让上月日期不可见
        }
        else if (d.Date.Month.Equals(intCurrentMonth))
        {
            string query = "select Name,StartTime,EndTime,Audit from NT_Instru,NT_Member where NT_Instru.MemberId = NT_Member.ID and DataId=" + dr["ID"] + " and #" + d.Date + "# between dateAdd('d',-1,StartTime) and EndTime";
            DataSet ds = DbHelperOleDb.ExecuteDataSet(CommandType.Text, query, null);
            if (ds != null && ds.Tables != null && ds.Tables.Count > 0 && ds.Tables[0].Rows != null && ds.Tables[0].Rows.Count > 0)
            {
                foreach (DataRow dr2 in ds.Tables[0].Rows)
                {
                    c.Controls.Add(new LiteralControl("<p style=\"font-size:10px; text-align:left;\">"));
                    if (int.Parse(dr2["Audit"].ToString()) == 0)
                    {
                        c.Controls.Add(new LiteralControl("<lable style=\"color:#0000ff;\">审核中</lable>"));
                    }
                    else if (int.Parse(dr2["Audit"].ToString()) == 1)
                    {
                        c.Controls.Add(new LiteralControl("<lable style=\"color:#00ff00;\">预约成功</lable>"));
                    }
                    else if (int.Parse(dr2["Audit"].ToString()) == 2)
                    {
                        c.Controls.Add(new LiteralControl("<lable style=\"color:#ff0000;\">预约失败</lable>"));
                    }
                    else if (int.Parse(dr2["Audit"].ToString()) == 3)
                    {
                        c.Controls.Add(new LiteralControl("<lable style=\"color:#ff0000;\">已取消</lable>"));
                    }
                    c.Controls.Add(new LiteralControl(" " + dr2["Name"] + " " + DateTimeFunc.dateFormat(DateTime.Parse(dr2["StartTime"].ToString()), 9, "-") + "-" + DateTimeFunc.dateFormat(DateTime.Parse(dr2["EndTime"].ToString()), 9, "-") + "</p>"));
                }
            }
            ds.Clear();

            string title = d.Date.Month.ToString() + "月" + d.Date.Day.ToString() + "日";
            string date = d.Date.ToShortDateString();

            if (d.Date < DateTime.Now.Date)
            {
                c.Controls.Add(new LiteralControl("<a href='javascript:void(0);' title='" + "不能预约已过日期" + "'>" + d.Date.Day + "</a>"));
            }
            else if (d.Date.DayOfWeek == DayOfWeek.Sunday)
            {
                c.Controls.Add(new LiteralControl("<a href='javascript:void(0);' title='" + "不能预约星期日" + "'>" + d.Date.Day + "</a>"));
            }
            else if (d.Date.DayOfWeek == DayOfWeek.Saturday)
            {
                c.Controls.Add(new LiteralControl("<a href='javascript:void(0);' title='" + "不能预约星期六" + "'>" + d.Date.Day + "</a>"));
            }
            else if (d.Date < DateTimeFunc.AddWorkDays(DateTime.Now, 2))
            {
                c.Controls.Add(new LiteralControl("<a href='javascript:void(0);' title='" + "不能预约三个工作日内" + "'>" + d.Date.Day + "</a>"));
            }
            else
            {
                c.Controls.Add(new LiteralControl("<a href='orderadd.aspx?iid=" + dr["ID"] + "&date=" + date + "' title='" + title + "'>" + d.Date.Day + "</a>"));
            }
        }
        else if (d.Date.Month.Equals(intNextMonth))
        {
            c.Controls.Clear();//让下月日期不可见
        }

    }
}
