﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;
using System.Data;
using System.Data.OleDb;
using System.Text.RegularExpressions;

public partial class register : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (IsPostBack)
            return;

        lit_xieyi.Text = FrontFunc.GetClassByID("292")["PageContent"].ToString();
    }

    //注册用户
    protected void imgbtn_ok_Click(object sender, ImageClickEventArgs e)
    {
        if (this.txt_Account.Text.Trim() != "" && this.txt_Pwd1.Text.Trim() != "" && this.txt_Pwd2.Text.Trim() != "" && this.txt_Name.Text.Trim() != "" && this.ddl_Identity.SelectedValue != "")
        {
            Regex reg1 = new Regex(@"^[A-Za-z0-9]\w{5,17}$");
            Regex reg2 = new Regex(@"^[A-Za-z0-9]\w{5,17}$");
            if (!reg1.IsMatch(txt_Account.Text.Trim()))
            {
                JavaScriptFunc.Alert(this.Page, "长度在6~18之间，字母、数字、组合均可");
                return;
            }
            if (!reg2.IsMatch(txt_Pwd1.Text.Trim()))
            {
                JavaScriptFunc.Alert(this.Page, "长度在6~18之间，字母、数字、组合均可");
                return;
            }

            if (txt_Pwd1.Text.Trim() != txt_Pwd2.Text.Trim())
            {
                JavaScriptFunc.Alert(this.Page, "两次输入密码不一致");
                return;
            }

            StringBuilder strSql1 = new StringBuilder();
            strSql1.Append("select count(*) from NT_Member");
            strSql1.Append(" where Account=@Account");
            OleDbParameter[] parameters1 = {
					new OleDbParameter("@Account", OleDbType.VarChar)};
            parameters1[0].Value = txt_Account.Text;
            object obj = DbHelperOleDb.ExecuteScalar(CommandType.Text, strSql1.ToString(), parameters1);
            if (obj.ToString() != "0")
            {
                JavaScriptFunc.Alert(this.Page, "账号已存在！");
                return;
            }

            //执行语句

            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into NT_Member(");
            strSql.Append("[Account],[Password],[Name],[Sex],[Identity],[Grade],[Number],[Teacher],[Remark],[RegTime])");
            strSql.Append(" values (");
            strSql.Append("@Account,@Password,@Name,@Sex,@Identity,@Grade,Number,Teacher,Remark,RegTime)");
            OleDbParameter[] parameters = {
					new OleDbParameter("@Account", OleDbType.VarChar),
					new OleDbParameter("@Password", OleDbType.VarChar),
                    new OleDbParameter("@Name", OleDbType.VarChar),
                    new OleDbParameter("@Sex", OleDbType.VarChar),
                    new OleDbParameter("@Identity", OleDbType.VarChar),
                    new OleDbParameter("@Grade", OleDbType.VarChar),
                    new OleDbParameter("@Number", OleDbType.VarChar),
                    new OleDbParameter("@Teacher", OleDbType.VarChar),
                    new OleDbParameter("@Remark", OleDbType.VarChar),
                    new OleDbParameter("@RegTime", OleDbType.Date)};
            parameters[0].Value = StringFunc.DataFilter(txt_Account.Text.Trim());
            parameters[1].Value = StringFunc.DataFilter(PageFunc.GetMd5(txt_Pwd1.Text.Trim()));
            parameters[2].Value = StringFunc.DataFilter(txt_Name.Text.Trim());
            parameters[3].Value = rb_Men.Checked == true ? "男" : "女";
            parameters[4].Value = ddl_Identity.SelectedValue;
            parameters[5].Value = StringFunc.DataFilter(txt_Grade.Text.Trim());
            parameters[6].Value = StringFunc.DataFilter(txt_Number.Text.Trim());
            parameters[7].Value = StringFunc.DataFilter(txt_Teacher.Text.Trim());
            parameters[8].Value = StringFunc.DataFilter(txt_Remark.Text.Trim());
            parameters[9].Value = DateTime.Now;

            try
            {
                DbHelperOleDb.ExecuteNonQuery(CommandType.Text, strSql.ToString(), parameters);
                object obj2 = DbHelperOleDb.ExecuteScalar(CommandType.Text, "select ID from NT_Member where Account='" + txt_Account.Text.Trim() + "'", null);

                Session["Account1"] = txt_Account.Text.Trim();
                Session["Name1"] = txt_Name.Text.Trim();
                Session["ID1"] = obj2;
                JavaScriptFunc.AlertAndRedirect(this.Page, "注册成功", "index.aspx");
            }
            catch (Exception)
            {
                JavaScriptFunc.Alert(this.Page, "注册失败");
            }

        }
        else
        {
            JavaScriptFunc.Alert(this.Page, "请完善您的信息，否则注册失败");
            return;
        }
    }
}
