﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;
using System.Data.OleDb;
using System.Data;

public partial class index : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (IsPostBack)
            return;

        #region 首页轮播效果
        DataTable dt_Advertising = FrontFunc.GetAdvertising();

        int i=0;
        foreach (DataRow dr in dt_Advertising.Rows)
        {
            lit_adv1.Text += "<dd><a href='" + dr["WebPath"] + "'><img src='" + dr["FilePath"] + "'/></a></dd>\r\n";
            string cur = i == 0 ? "class=\"cur\"" : "";
            lit_adv2.Text += "<dd " + cur + "></dd>\r\n";
            i++;
        }
        #endregion

        #region 规章制度
        DataTable dt_gzzd = FrontFunc.GetDataByClassID("6", "285", "");
        foreach (DataRow dr in dt_gzzd.Rows)
        {
            lit_gzzd.Text += "<li><a href='gzzddetails.aspx?gid=" + dr["ID"] + "' title='" + dr["Title"] + "'>" + FrontFunc.Cutstring(dr["Title"].ToString(), 13) + "</a></li>";
        }
        #endregion

        #region 新闻公告
        DataTable dt_news = FrontFunc.GetDataByClassID("7", "286", "");
        foreach (DataRow dr in dt_news.Rows)
        {
            lit_news.Text += "<li><cite>"+DateTimeFunc.dateFormat(DateTime.Parse(dr["AddTime"].ToString()),3,"-")+"</cite>·<a href='newsdetails.aspx?nid="+dr["ID"]+"' title='"+dr["Title"]+"'>"+FrontFunc.Cutstring(dr["Title"].ToString(),35)+"</a></li>";
        }
        #endregion

        #region 资料下载
        DataTable dt_download = FrontFunc.GetDataByClassID("7", "287", "");
        foreach (DataRow dr in dt_download.Rows)
        {
            lit_download.Text += "<li><cite>" + DateTimeFunc.dateFormat(DateTime.Parse(dr["AddTime"].ToString()), 3, "-") + "</cite>·<a href='" + dr["FilePath"] + "' title='" + dr["Title"] + "'>" + FrontFunc.Cutstring(dr["Title"].ToString(), 35) + "</a></li>";
        }
        #endregion

        #region 教学视频
        DataTable dt_video = FrontFunc.GetDataByClassID("1", "288", "");
        foreach (DataRow dr in dt_video.Rows)
        {
            if (Session["Account1"] == null || Session["Account1"].ToString() == "")
                lit_video.Text += dr["Video1"];
            else
                lit_video.Text += dr["Video2"];
        }
        #endregion


        #region 学校链接
        DataTable dt_link1 = FrontFunc.GetLinks("ALL", "学院链接");
        DataTable dt_link2 = FrontFunc.GetLinks("ALL", "友情链接");

        foreach (DataRow dr in dt_link1.Rows)
        {
            lit_link1.Text += "<option value='" + dr["LinkPath"] + "'> " + dr["Title"] + " </option>";
        }

        foreach (DataRow dr in dt_link2.Rows)
        {
            lit_link2.Text += "<option value='" + dr["LinkPath"] + "'> " + dr["Title"] + " </option>";
        }
        #endregion
    }

    //登录
    protected void btnLogin_Click(object sender, EventArgs e)
    {
        if (this.txt_Account.Text.Trim() == "" || this.txt_Pwd.Text.Trim() == "")
        {
            JavaScriptFunc.Alert(this.Page, "用户名和密码不能为空");
        }
        else
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select * from NT_Member ");
            sb.Append(" where Account=@Account and Password=@Password");
            OleDbParameter[] parameters = { new OleDbParameter("@Account", OleDbType.VarChar), new OleDbParameter("@Password", OleDbType.VarChar) };
            parameters[0].Value = StringFunc.DataFilter(txt_Account.Text.Trim());
            parameters[1].Value = StringFunc.DataFilter(PageFunc.GetMd5(txt_Pwd.Text.Trim()));

            OleDbDataReader odr = DbHelperOleDb.ExecuteDataReader(CommandType.Text, sb.ToString(), parameters);

            if (odr.HasRows)
            {
                while (odr.Read())
                {
                    Session["Account1"] = odr["Account"];
                    Session["Name1"] = odr["Name"];
                    Session["ID1"] = odr["ID"];
                }
            }
            else
            {
                JavaScriptFunc.Alert(this.Page, "用户名和密码不正确");
            }
        }
    }
}
