﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;
using System.Data.OleDb;
using System.Data;

public partial class HeadLeftFoot : System.Web.UI.MasterPage
{

    protected void Page_Load(object sender, EventArgs e)
    {
        if (IsPostBack)
            return;

        #region 网站设置--标题、关键字等
        DataTable dt_Siteconfig = FrontFunc.GetSiteconfig();
        foreach (DataRow dr in dt_Siteconfig.Rows)
        {
            if (dr["Type"].ToString() == "标题")
            {
                this.lit_WebTitle.Text += "<title>" + dr["Content"] + "</title>";
            }
            if (dr["Type"].ToString() == "关键字")
            {
                this.lit_WebKeyWords.Text += "<meta name=\"KeyWords\" content=\"" + dr["Content"] + "\">";
            }
            if (dr["Type"].ToString() == "描述")
            {
                this.lit_WebDescription.Text += "<meta name=\"Description\" content=\"" + dr["Content"] + "\">";
            }
        }
        #endregion


        #region 日期
        lit_date.Text = DateTimeFunc.DateNow() + " " + DateTimeFunc.WeekDay();
        #endregion


        #region 规章制度
        DataTable dt_gzzd = FrontFunc.GetDataByClassID("6", "285", "");
        foreach (DataRow dr in dt_gzzd.Rows)
        {
            lit_gzzd.Text += "<li><a href='gzzddetails.aspx?gid="+dr["ID"]+"' title='"+dr["Title"]+"'>"+FrontFunc.Cutstring(dr["Title"].ToString(),13)+"</a></li>";
        }
        #endregion


        #region 学校链接
        DataTable dt_link1 = FrontFunc.GetLinks("ALL", "学院链接");
        DataTable dt_link2 = FrontFunc.GetLinks("ALL", "友情链接");

        foreach (DataRow dr in dt_link1.Rows)
        {
            lit_link1.Text += "<option value='" + dr["LinkPath"] + "'>-------- " + dr["Title"] + " --------</option>";
        }

        foreach (DataRow dr in dt_link2.Rows)
        {
            lit_link2.Text += "<option value='" + dr["LinkPath"] + "'>-------- " + dr["Title"] + " --------</option>";
        }
        #endregion


    }

    //登录
    protected void Button1_Click(object sender, EventArgs e)
    {
        if (this.txt_Account.Text.Trim() == "" || this.txt_Pwd.Text.Trim() == "")
        {
            JavaScriptFunc.Alert(this.Page, "用户名和密码不能为空");
        }
        else
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select * from NT_Member ");
            sb.Append(" where Account=@Account and Password=@Password");
            OleDbParameter[] parameters = { new OleDbParameter("@Account", OleDbType.VarChar), new OleDbParameter("@Password", OleDbType.VarChar) };
            parameters[0].Value = StringFunc.DataFilter(txt_Account.Text.Trim());
            parameters[1].Value = StringFunc.DataFilter(PageFunc.GetMd5(txt_Pwd.Text.Trim()));

            OleDbDataReader odr = DbHelperOleDb.ExecuteDataReader(CommandType.Text, sb.ToString(), parameters);

            if (odr.HasRows)
            {
                while (odr.Read())
                {
                    Session["Account1"] = odr["Account"];
                    Session["Name1"] = odr["Name"];
                    Session["ID1"] = odr["ID"];
                }
            }
            else
            {
                JavaScriptFunc.Alert(this.Page, "用户名和密码不正确");
            }
        }
    }


}
