﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Text;
public partial class BackCenter_User_UserEdit : System.Web.UI.Page
{
    //页面加载
    protected void Page_Load(object sender, EventArgs e)
    {
        #region 过期和权限

        PageFunc.IfLogin(this.Page);
        //PubPageFunc.PageHavePurview(this.Page, "2001");

        #endregion
        if (!IsPostBack)
        {
            #region 绑定DropDownList
            string sql1 = "select ID,Name,OrderNum from NT_Role where CreateUserId=" + Session["ID"] + "  order by OrderNum asc";
            WebControlsFunc.BindToDropDownList(ddl_Role, sql1, "Name", "ID", "请选择","");

            string sql2 = "select ID,Name,OrderNum from NT_Department order by OrderNum asc";
            WebControlsFunc.BindToDropDownList(ddl_Department, sql2, "Name", "ID", "请选择","");
            #endregion

            #region 页面赋值
            if (Request["ID"] != null && Request["ID"] != "")
            {
                StringBuilder strSql = new StringBuilder();
                strSql.Append("select ID,Account,Password,RealName,RoleId,DepartmentId from NT_User ");
                strSql.Append(" where ID=@ID");
                OleDbParameter[] parameters = { new OleDbParameter("@ID", OleDbType.Integer, 4) };
                parameters[0].Value = Request["ID"];

                OleDbDataReader sdr = DbHelperOleDb.ExecuteDataReader(CommandType.Text, strSql.ToString(), parameters);
                if (sdr.HasRows)
                {
                    while (sdr.Read())
                    {
                        this.txt_Account.Text = sdr["Account"].ToString();
                        this.txt_RealName.Text = sdr["RealName"].ToString();
                        this.ddl_Role.SelectedValue = sdr["RoleId"].ToString();
                        this.ddl_Department.SelectedValue = sdr["DepartmentId"].ToString();
                    }
                }
                sdr.Close();
            }
            #endregion
        }
    }

    //保存事件
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (Request["ID"] != null && Request["ID"] != "")
        {
            #region 判断Account重复
            StringBuilder strSql1 = new StringBuilder();
            strSql1.Append("select count(*) from NT_User");
            strSql1.Append(" where Account=@Account and ID<>" + Request["ID"] + "");
            OleDbParameter[] parameters1 = {
					new OleDbParameter("@Account", OleDbType.VarChar)};
            parameters1[0].Value = txt_Account.Text;


            object obj = DbHelperOleDb.ExecuteScalar(CommandType.Text, strSql1.ToString(), parameters1);
            if (obj.ToString() != "0")
            {
                JavaScriptFunc.Alert(this.Page, "账号不能重复！");
                return;
            }
            #endregion

            #region 操作数据库
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update NT_User set ");
            strSql.Append("[Account]=@Account,");
            strSql.Append("[RealName]=@RealName,");
            strSql.Append("[RoleId]=@RoleId,");
            strSql.Append("[DepartmentId]=@DepartmentId");
            strSql.Append(" where ID=@ID");
            OleDbParameter[] parameters = {
					new OleDbParameter("@Account", OleDbType.VarChar),

                    new OleDbParameter("@RealName", OleDbType.VarChar),
					new OleDbParameter("@RoleId", OleDbType.Integer,4),
                    new OleDbParameter("@DepartmentId", OleDbType.Integer,4),
					new OleDbParameter("@ID", OleDbType.Integer,4)};
            parameters[0].Value = txt_Account.Text;
            parameters[1].Value = txt_RealName.Text;
            parameters[2].Value = ddl_Role.SelectedItem.Value;
            parameters[3].Value = ddl_Department.SelectedItem.Value;
            parameters[4].Value = Request["ID"];
            //执行语句
            DbHelperOleDb.ExecuteNonQuery(CommandType.Text, strSql.ToString(), parameters);


            #endregion

            JavaScriptFunc.AlertAndRedirect(this.Page, "修改成功", "UserIndex.aspx");
        }
        else
        {

            #region 判断Account重复
            StringBuilder strSql1 = new StringBuilder();
            strSql1.Append("select count(*) from NT_User");
            strSql1.Append(" where Account=@Account");
            OleDbParameter[] parameters1 = {
					new OleDbParameter("@Account", OleDbType.VarChar)};
            parameters1[0].Value = txt_Account.Text;


            object obj = DbHelperOleDb.ExecuteScalar(CommandType.Text, strSql1.ToString(), parameters1);
            if (obj.ToString() != "0")
            {
                JavaScriptFunc.Alert(this.Page, "账号不能重复！");
                return;
            }
            #endregion

            #region 操作数据库
            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into NT_User(");
            strSql.Append("[Account],[Password],[RealName],[RoleId],[DepartmentId],[CreateUserId])");
            strSql.Append(" values (");
            strSql.Append("@Account,@Password,@RealName,@RoleId,@DepartmentId,@CreateUserId)");
            OleDbParameter[] parameters = {
					new OleDbParameter("@Account", OleDbType.VarChar),
                    new OleDbParameter("@Password", OleDbType.VarChar),
                    new OleDbParameter("@RealName", OleDbType.VarChar),
					new OleDbParameter("@RoleId", OleDbType.Integer,4),
                    new OleDbParameter("@DepartmentId", OleDbType.Integer,4),
                    new OleDbParameter("@CreateUserId",OleDbType.Integer,4)};
            parameters[0].Value = txt_Account.Text;
            parameters[1].Value = PageFunc.GetMd5("888888");
            parameters[2].Value = txt_RealName.Text;
            parameters[3].Value = ddl_Role.SelectedItem.Value;
            parameters[4].Value = ddl_Department.SelectedItem.Value;
            parameters[5].Value = Session["ID"];

            DbHelperOleDb.ExecuteNonQuery(CommandType.Text, strSql.ToString(), parameters);


            #endregion

            JavaScriptFunc.AlertAndRedirect(this.Page, "添加成功", "UserIndex.aspx");
        }
    }
}
