﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Text;
public partial class BackCenter_Siteconfig_SiteconfigEdit : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        #region 过期和权限

        PageFunc.IfLogin(this.Page);
        //PubPageFunc.PageHavePurview(this.Page, "2001");

        #endregion

        if (!IsPostBack)
        {
            #region 页面赋值
            if (Request["ID"] != null)
            {

                StringBuilder strSql = new StringBuilder();
                strSql.Append("select [ID],[Type],[Content] from NT_Siteconfig ");
                strSql.Append(" where ID=@ID");
                OleDbParameter[] parameters = { new OleDbParameter("@ID", OleDbType.Integer, 4) };
                parameters[0].Value = Request["ID"];

                OleDbDataReader sdr = DbHelperOleDb.ExecuteDataReader(CommandType.Text, strSql.ToString(), parameters);
                if (sdr.HasRows)
                {
                    while (sdr.Read())
                    {
                        WebControlsFunc.SelectDropDownList(this.ddl_Type, sdr["Type"].ToString());
                        this.txt_Content.Text = sdr["Content"].ToString();
                    }
                    sdr.Close();
                }
            }
            #endregion
        }
    }

    //保存
    protected void btnSave_Click(object sender, EventArgs e)
    {
        string str_Type = this.ddl_Type.SelectedValue;
        string str_Content = this.txt_Content.Text;
        string str_ID = Request["ID"];

        if (Request["ID"] != null && Request["ID"] != "")
        {
            #region 每个类型只能加一条
            StringBuilder strSql1 = new StringBuilder();
            strSql1.Append("select count(*) from NT_Siteconfig");
            strSql1.Append(" where Type=@Type and ID<>" + str_ID + "");
            OleDbParameter[] parameters1 = {
					new OleDbParameter("@Type", OleDbType.VarChar)};
            parameters1[0].Value = str_Type;


            object obj = DbHelperOleDb.ExecuteScalar(CommandType.Text, strSql1.ToString(), parameters1);
            if (obj.ToString() != "0")
            {
                JavaScriptFunc.Alert(this.Page, "已经添加了该类型！");
                return;
            }
            #endregion

            #region 操作数据库


            StringBuilder strSql = new StringBuilder();
            strSql.Append("update NT_Siteconfig set ");
            strSql.Append("Type=@Type,");
            strSql.Append("Content=@Content ");
            strSql.Append(" where ID=@ID");
            OleDbParameter[] parameters = {
					new OleDbParameter("@Type", OleDbType.VarChar),
					new OleDbParameter("@Content", OleDbType.VarChar),
					new OleDbParameter("@ID", OleDbType.Integer,4)};
            parameters[0].Value = str_Type;
            parameters[1].Value = str_Content;
            parameters[2].Value = str_ID;
            //执行语句
            DbHelperOleDb.ExecuteNonQuery(CommandType.Text, strSql.ToString(), parameters);


            #endregion

            JavaScriptFunc.AlertAndRedirect(this.Page, "修改成功", "SiteconfigIndex.aspx");
        }
        else
        {
            #region 每个类型只能加一条
            StringBuilder strSql1 = new StringBuilder();
            strSql1.Append("select count(*) from NT_Siteconfig");
            strSql1.Append(" where Type=@Type");
            OleDbParameter[] parameters1 = {
					new OleDbParameter("@Type", OleDbType.VarChar)};
            parameters1[0].Value = str_Type;


            object obj = DbHelperOleDb.ExecuteScalar(CommandType.Text, strSql1.ToString(), parameters1);
            if (obj.ToString() != "0")
            {
                JavaScriptFunc.Alert(this.Page, "已经添加了该类型！");
                return;
            }
            #endregion

            #region 操作数据库
            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into NT_Siteconfig(");
            strSql.Append("[Type],[Content])");
            strSql.Append(" values (");
            strSql.Append("@Type,@Content)");
            OleDbParameter[] parameters = {
					new OleDbParameter("@Type", OleDbType.VarChar),
					new OleDbParameter("@Content", OleDbType.VarChar)};
            parameters[0].Value = str_Type;
            parameters[1].Value = str_Content;

            DbHelperOleDb.ExecuteNonQuery(CommandType.Text, strSql.ToString(), parameters);


            #endregion

            JavaScriptFunc.AlertAndRedirect(this.Page, "添加成功", "SiteconfigIndex.aspx");
        }
    }
}
