﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Text;
public partial class BackCenter_SiteType_SiteTypeEdit : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        #region 过期和权限

        PageFunc.IfLogin(this.Page);
        //PubPageFunc.PageHavePurview(this.Page, "2001");

        #endregion
        if (!IsPostBack)
        {
            #region 页面赋值
            if (Request["ID"] != null)
            {

                StringBuilder strSql = new StringBuilder();
                strSql.Append("select ID,Name,Remark,OrderNum from NT_SiteType ");
                strSql.Append(" where ID=@ID");
                OleDbParameter[] parameters = { new OleDbParameter("@ID", OleDbType.Integer, 4) };
                parameters[0].Value = Request["ID"];

                OleDbDataReader sdr = DbHelperOleDb.ExecuteDataReader(CommandType.Text, strSql.ToString(), parameters);
                if (sdr.HasRows)
                {
                    while (sdr.Read())
                    {
                        this.txt_Name.Text = sdr["Name"].ToString();
                        this.txt_Remark.Text = sdr["Remark"].ToString();
                        this.txt_OrderNum.Text = sdr["OrderNum"].ToString();
                    }
                }
                sdr.Close();
            }
            #endregion
        }
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (Request["ID"] != null && Request["ID"] != "")
        {
            #region 操作数据库
            StringBuilder strSql1 = new StringBuilder();
            strSql1.Append("select count(*) from NT_SiteType");
            strSql1.Append(" where Name=@Name and ID<>@ID");
            OleDbParameter[] parameters1 = {
					new OleDbParameter("@Name", OleDbType.VarChar),
                    new OleDbParameter("@ID", OleDbType.Integer,4)};
            parameters1[0].Value = txt_Name.Text;
            parameters1[1].Value = Request["ID"];


            object obj = DbHelperOleDb.ExecuteScalar(CommandType.Text, strSql1.ToString(), parameters1);
            if (obj.ToString() != "0")
            {
                JavaScriptFunc.Alert(this.Page, "名称不能重复！");
                return;
            }


            StringBuilder strSql = new StringBuilder();
            strSql.Append("update NT_SiteType set ");
            strSql.Append("Name=@Name,");
            strSql.Append("Remark=@Remark,");
            strSql.Append("OrderNum=@OrderNum");
            strSql.Append(" where ID=@ID");
            OleDbParameter[] parameters = {
					new OleDbParameter("@Name", OleDbType.VarChar),
                    new OleDbParameter("@Remark", OleDbType.VarChar),
					new OleDbParameter("@OrderNum", OleDbType.Integer,4),
					new OleDbParameter("@ID", OleDbType.Integer,4)};
            parameters[0].Value = txt_Name.Text;
            parameters[1].Value = txt_Remark.Text;
            parameters[2].Value = txt_OrderNum.Text;
            parameters[3].Value = Request["ID"];
            //执行语句
            DbHelperOleDb.ExecuteNonQuery(CommandType.Text, strSql.ToString(), parameters);


            #endregion

            JavaScriptFunc.AlertAndRedirect(this.Page, "修改成功", "SiteTypeIndex.aspx");
        }
        else
        {
            #region 操作数据库
            StringBuilder strSql1 = new StringBuilder();
            strSql1.Append("select count(*) from NT_SiteType");
            strSql1.Append(" where Name=@Name");
            OleDbParameter[] parameters1 = {
					new OleDbParameter("@Name", OleDbType.VarChar)};
            parameters1[0].Value = txt_Name.Text;


            object obj = DbHelperOleDb.ExecuteScalar(CommandType.Text, strSql1.ToString(), parameters1);
            if (obj.ToString() != "0")
            {
                JavaScriptFunc.Alert(this.Page, "名称不能重复！");
                return;
            }

            //执行语句

            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into NT_SiteType(");
            strSql.Append("Name,Remark,OrderNum)");
            strSql.Append(" values (");
            strSql.Append("@Name,@Remark,@OrderNum)");
            OleDbParameter[] parameters = {
					new OleDbParameter("@Name", OleDbType.VarChar),
                    new OleDbParameter("@Remark", OleDbType.VarChar),
					new OleDbParameter("@OrderNum", OleDbType.Integer)};
            parameters[0].Value = txt_Name.Text;
            parameters[1].Value = txt_Name.Text;
            parameters[2].Value = txt_OrderNum.Text;

            DbHelperOleDb.ExecuteNonQuery(CommandType.Text, strSql.ToString(), parameters);


            #endregion

            JavaScriptFunc.AlertAndRedirect(this.Page, "添加成功", "SiteTypeIndex.aspx");
        }
    }
}
