﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Text;
public partial class BackCenter_Site_SiteEdit : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        #region 过期和权限

        PageFunc.IfLogin(this.Page);
        //PubPageFunc.PageHavePurview(this.Page, "2001");

        #endregion
        if (!IsPostBack)
        {
            //栏目下拉框
            string sql = "select Id,Name from NT_SiteType order by OrderNum asc,ID desc";
            WebControlsFunc.BindToDropDownList(this.ddl_SiteTypeId, sql, "Name", "Id", "请选择","");

            #region 页面赋值
            if (Request["ID"] != null)
            {

                StringBuilder strSql = new StringBuilder();
                strSql.Append("select [Id],[SiteTypeId],[SiteName],[SiteImg],[SiteFeature],[SiteInfo],[SiteDescription],[SitePrice],[SiteCycle],[SiteAttachment],[UserId] from NT_Site ");
                strSql.Append(" where ID=@ID");
                OleDbParameter[] parameters = { new OleDbParameter("@ID", OleDbType.Integer, 4) };
                parameters[0].Value = Request["ID"];

                OleDbDataReader sdr = DbHelperOleDb.ExecuteDataReader(CommandType.Text, strSql.ToString(), parameters);
                if (sdr.HasRows)
                {
                    while (sdr.Read())
                    {
                        WebControlsFunc.SelectDropDownList(this.ddl_SiteTypeId, sdr["SiteTypeId"].ToString());
                        this.txt_SiteName.Text = sdr["SiteName"].ToString();
                        this.txt_SitePrice.Text = sdr["SitePrice"].ToString();
                        if (sdr["SiteImg"].ToString().Length > 0)
                        {
                            this.img_SiteImg.ImageUrl = sdr["SiteImg"].ToString();
                            this.img_SiteImg.Visible = true;
                        }


                        this.txt_SiteCycle.Text = sdr["SiteCycle"].ToString();
                        this.txt_SiteFeature.Text = sdr["SiteFeature"].ToString();
                        this.txt_SiteInfo.Text = sdr["SiteInfo"].ToString();
                        this.FileContent.Text = sdr["SiteDescription"].ToString();

                        if (sdr["SiteAttachment"].ToString().Length > 0)
                        {
                            this.lab_SiteAttachment.Text = "<a  href='" + sdr["SiteAttachment"].ToString() + "' target='_blank'>下载</a>";
                            this.lab_SiteAttachmentBak.Text = sdr["SiteAttachment"].ToString();
                        }
                    }
                }
                sdr.Close();
            }
            #endregion
        }
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        string str_SiteTypeId = this.ddl_SiteTypeId.SelectedValue;
        string str_SiteName = this.txt_SiteName.Text;

        string str_SiteImg = this.img_SiteImg.ImageUrl;
        #region 图片
        if (this.fu_SiteImg != null && this.fu_SiteImg.FileName.Length > 0)
        {
            #region 判断类型
            string[] arrExtension = new string[] { ".gif", ".jpg", ".jpeg", ".bmp", ".png", ".JPG" };
            if (FileFunc.IsAllowedExtension(fu_SiteImg, arrExtension) == false)
            {
                JavaScriptFunc.Alert(this.Page, "图片格式必须是.gif, .jpg, .jpeg, .bmp, .png, .JPG");
                return;
            }
            #endregion
            //赋值
            str_SiteImg = FileFunc.CreateFile(this.Page, fu_SiteImg);
        }
        #endregion


        string str_SiteFeature = this.txt_SiteFeature.Text;
        string str_SiteInfo = this.txt_SiteInfo.Text;
        string str_SiteDescription = this.FileContent.Text;
        string str_SitePrice = this.txt_SitePrice.Text;
        string str_SiteCycle = this.txt_SiteCycle.Text;

        string str_SiteAttachment = this.lab_SiteAttachmentBak.Text;

        #region 附件
        if (this.fu_SiteAttachment != null && this.fu_SiteAttachment.FileName.Length > 0)
        {
            //赋值
            str_SiteAttachment = FileFunc.CreateFile(this.Page, fu_SiteAttachment);
        }
        #endregion

        string str_UserId = Session["ID"].ToString();

        if (Request["ID"] != null && Request["ID"] != "")
        {
            #region 操作数据库
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update NT_Site set ");
            strSql.Append("SiteTypeId=@SiteTypeId,");
            strSql.Append("SiteName=@SiteName,");
            strSql.Append("SiteImg=@SiteImg,");
            strSql.Append("SiteFeature=@SiteFeature,");
            strSql.Append("SiteInfo=@SiteInfo,");
            strSql.Append("SiteDescription=@SiteDescription,");
            strSql.Append("SitePrice=@SitePrice,");
            strSql.Append("SiteCycle=@SiteCycle,");
            strSql.Append("SiteAttachment=@SiteAttachment,");
            strSql.Append("UserId=@UserId");
            strSql.Append(" where ID=@ID");
            OleDbParameter[] parameters = {
					new OleDbParameter("@SiteTypeId", OleDbType.Integer,4),
					new OleDbParameter("@SiteName", OleDbType.VarChar),
                    new OleDbParameter("@SiteImg", OleDbType.VarChar),
                    new OleDbParameter("@SiteFeature", OleDbType.VarChar),
                    new OleDbParameter("@SiteInfo", OleDbType.VarChar),
                    new OleDbParameter("@SiteDescription", OleDbType.VarChar),
                    new OleDbParameter("@SitePrice", OleDbType.VarChar),
                    new OleDbParameter("@SiteCycle", OleDbType.VarChar),
                    new OleDbParameter("@SiteAttachment", OleDbType.VarChar),
                    new OleDbParameter("@UserId", OleDbType.Integer,4),
                    new OleDbParameter("@ID", OleDbType.Integer,4)};
            parameters[0].Value = str_SiteTypeId;
            parameters[1].Value = str_SiteName;
            parameters[2].Value = str_SiteImg;
            parameters[3].Value = str_SiteFeature;
            parameters[4].Value = str_SiteInfo;
            parameters[5].Value = str_SiteDescription;
            parameters[6].Value = str_SitePrice;
            parameters[7].Value = str_SiteCycle;
            parameters[8].Value = str_SiteAttachment;
            parameters[9].Value = str_UserId;
            parameters[10].Value = Request["ID"];
            //执行语句
            DbHelperOleDb.ExecuteNonQuery(CommandType.Text, strSql.ToString(), parameters);


            #endregion

            JavaScriptFunc.AlertAndRedirect(this.Page, "修改成功", "SiteIndex.aspx");
        }
        else
        {
            #region 操作数据库

            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into NT_Site(");
            strSql.Append("[SiteTypeId],[SiteName],[SiteImg],[SiteFeature],[SiteInfo],[SiteDescription],[SitePrice],[SiteCycle],[SiteAttachment],[UserId] )");
            strSql.Append(" values (");
            strSql.Append("@SiteTypeId,@SiteName,@SiteImg,@SiteFeature,@SiteInfo,@SiteDescription,@SitePrice,@SiteCycle,@SiteAttachment,@UserId)");
            OleDbParameter[] parameters = {
					new OleDbParameter("@SiteTypeId", OleDbType.Integer,4),
					new OleDbParameter("@SiteName", OleDbType.VarChar),
                    new OleDbParameter("@SiteImg", OleDbType.VarChar),
                    new OleDbParameter("@SiteFeature", OleDbType.VarChar),
                    new OleDbParameter("@SiteInfo", OleDbType.VarChar),
                    new OleDbParameter("@SiteDescription", OleDbType.VarChar),
                    new OleDbParameter("@SitePrice", OleDbType.VarChar),
                    new OleDbParameter("@SiteCycle", OleDbType.VarChar),
                    new OleDbParameter("@SiteAttachment", OleDbType.VarChar),
                    new OleDbParameter("@UserId", OleDbType.Integer,4)};
            parameters[0].Value = str_SiteTypeId;
            parameters[1].Value = str_SiteName;
            parameters[2].Value = str_SiteImg;
            parameters[3].Value = str_SiteFeature;
            parameters[4].Value = str_SiteInfo;
            parameters[5].Value = str_SiteDescription;
            parameters[6].Value = str_SitePrice;
            parameters[7].Value = str_SiteCycle;
            parameters[8].Value = str_SiteAttachment;
            parameters[9].Value = str_UserId;

            DbHelperOleDb.ExecuteNonQuery(CommandType.Text, strSql.ToString(), parameters);


            #endregion

            JavaScriptFunc.AlertAndRedirect(this.Page, "添加成功", "SiteIndex.aspx");
        }
    }
}
