﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Text;
public partial class BackCenter_Resume_ResumeEdit : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        #region 过期和权限

        PageFunc.IfLogin(this.Page);
        //PubPageFunc.PageHavePurview(this.Page, "2001");

        #endregion
        if (!IsPostBack)
        {
            //页面赋值
            PageInit();

        }
    }


    //页面赋值
    protected void PageInit()
    {
        if (Request["ID"] != null)
        {

            StringBuilder strSql = new StringBuilder();
            strSql.Append("select ID,MemberId,PicturePath,HighEducation,LearnExp,WorkExp,Attachment from NT_Resume ");
            strSql.Append(" where ID=@ID");
            OleDbParameter[] parameters = { new OleDbParameter("@ID", OleDbType.Integer, 4) };
            parameters[0].Value = Request["ID"];

            OleDbDataReader sdr = DbHelperOleDb.ExecuteDataReader(CommandType.Text, strSql.ToString(), parameters);
            if (sdr.HasRows)
            {
                while (sdr.Read())
                {
                    this.txt_MemberId.Text = sdr["MemberId"].ToString();
                    if (sdr["PicturePath"].ToString().Length > 0)
                    {
                        this.img_PicturePath.ImageUrl = sdr["PicturePath"].ToString();
                        this.img_PicturePath.Visible = true;
                    }
                    this.txt_HighEducation.Text = sdr["HighEducation"].ToString();
                    this.txt_LearnExp.Text = sdr["LearnExp"].ToString();
                    this.txt_WorkExp.Text = sdr["WorkExp"].ToString();
                    if (sdr["Attachment"].ToString().Length > 0)
                    {
                        this.lab_Attachment.Text = "<a  href='" + sdr["Attachment"].ToString() + "' target='_blank'>下载</a>";
                        this.lab_AttachmentBak.Text = sdr["Attachment"].ToString();
                    }

                }
            }
            sdr.Close();
        }
    }

    //保存
    protected void btnSave_Click(object sender, EventArgs e)
    {
        string str_PicturePath = this.img_PicturePath.ImageUrl;

        #region 判断类型+保存图片
        if (this.fu_PicturePath != null && this.fu_PicturePath.FileName.Length > 0)
        {
            #region 判断类型
            string[] arrExtension = new string[] { ".gif", ".jpg", ".jpeg", ".bmp", ".png", ".JPG" };
            if (FileFunc.IsAllowedExtension(fu_PicturePath, arrExtension) == false)
            {
                JavaScriptFunc.Alert(this.Page, "图片格式必须是.gif, .jpg, .jpeg, .bmp, .png, .JPG");
                return;
            }
            #endregion
            //赋值
            str_PicturePath = FileFunc.CreateFile(this.Page, fu_PicturePath);
        }
        #endregion

        string str_Attachment = this.lab_AttachmentBak.Text;
        #region 附件
        if (this.fu_Attachment != null && this.fu_Attachment.FileName.Length > 0)
        {
            //赋值
            str_Attachment = FileFunc.CreateFile(this.Page, fu_Attachment);
        }
        #endregion

        if (Request["ID"] != null && Request["ID"] != "")
        {
            #region 操作数据库


            StringBuilder strSql = new StringBuilder();
            strSql.Append("update NT_Resume set ");
            strSql.Append("MemberId=@MemberId,");
            strSql.Append("PicturePath=@PicturePath,");
            strSql.Append("HighEducation=@HighEducation,");
            strSql.Append("LearnExp=@LearnExp,");
            strSql.Append("WorkExp=@WorkExp,");
            strSql.Append("Attachment=@Attachment");
            strSql.Append(" where ID=@ID");
            OleDbParameter[] parameters = {
                    new OleDbParameter("@MemberId", OleDbType.Integer,4),
					new OleDbParameter("@PicturePath", OleDbType.VarChar),
					new OleDbParameter("@HighEducation", OleDbType.VarChar),
                    new OleDbParameter("@LearnExp", OleDbType.VarChar),
					new OleDbParameter("@WorkExp", OleDbType.VarChar),
                    new OleDbParameter("@Attachment", OleDbType.VarChar),
					new OleDbParameter("@ID", OleDbType.Integer,4)};
            parameters[0].Value = txt_MemberId.Text;
            parameters[1].Value = str_PicturePath;
            parameters[2].Value = txt_HighEducation.Text;
            parameters[3].Value = txt_LearnExp.Text;
            parameters[4].Value = txt_WorkExp.Text;
            parameters[5].Value = str_Attachment;
            parameters[6].Value = Request["ID"];
            //执行语句
            DbHelperOleDb.ExecuteNonQuery(CommandType.Text, strSql.ToString(), parameters);


            #endregion

            JavaScriptFunc.AlertAndRedirect(this.Page, "修改成功", "ResumeIndex.aspx");
        }
        else
        {
            #region 操作数据库
            StringBuilder strSql1 = new StringBuilder();
            strSql1.Append("select count(*) from NT_Resume");
            strSql1.Append(" where MemberId=@MemberId");
            OleDbParameter[] parameters1 = {
					new OleDbParameter("@MemberId", OleDbType.Integer,4)};
            parameters1[0].Value = txt_MemberId.Text;


            object obj = DbHelperOleDb.ExecuteScalar(CommandType.Text, strSql1.ToString(), parameters1);
            if (obj.ToString() != "0")
            {
                JavaScriptFunc.Alert(this.Page, "会员简历不能重复！");
                return;
            }

            //执行语句

            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into NT_Resume(");
            strSql.Append("MemberId,PicturePath,HighEducation,LearnExp,WorkExp,Attachment)");
            strSql.Append(" values (");
            strSql.Append("@MemberId,@PicturePath,@HighEducation,@LearnExp,@WorkExp,@Attachment)");
            OleDbParameter[] parameters = {
					new OleDbParameter("@MemberId", OleDbType.Integer,4),
					new OleDbParameter("@PicturePath", OleDbType.VarChar),
					new OleDbParameter("@HighEducation", OleDbType.VarChar),
                    new OleDbParameter("@LearnExp", OleDbType.VarChar),
					new OleDbParameter("@WorkExp", OleDbType.VarChar),
                    new OleDbParameter("@Attachment", OleDbType.VarChar)};
            parameters[0].Value = txt_MemberId.Text;
            parameters[1].Value = str_PicturePath;
            parameters[2].Value = txt_HighEducation.Text;
            parameters[3].Value = txt_LearnExp.Text;
            parameters[4].Value = txt_WorkExp.Text;
            parameters[5].Value = str_Attachment;

            DbHelperOleDb.ExecuteNonQuery(CommandType.Text, strSql.ToString(), parameters);


            #endregion

            JavaScriptFunc.AlertAndRedirect(this.Page, "添加成功", "ResumeIndex.aspx");
        }
    }
}
