﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.OleDb;
using System.Text;
public partial class BackCenter_OnlineService_OnlineServiceEdit : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        #region 过期和权限

        PageFunc.IfLogin(this.Page);
        //PubPageFunc.PageHavePurview(this.Page, "2001");

        #endregion
        if (!IsPostBack)
        {
            //页面赋值
            PageInit();

        }
    }


    //页面赋值
    protected void PageInit()
    {
        if (Request["ID"] != null)
        {

            StringBuilder strSql = new StringBuilder();
            strSql.Append("select [ID],[Type],[Title],[PicturePath] , [Phone] ,[OrderNum] from NT_OnlineService ");
            strSql.Append(" where ID=@ID");
            OleDbParameter[] parameters = { new OleDbParameter("@ID", OleDbType.Integer, 4) };
            parameters[0].Value = Request["ID"];

            OleDbDataReader sdr = DbHelperOleDb.ExecuteDataReader(CommandType.Text, strSql.ToString(), parameters);
            if (sdr.HasRows)
            {
                while (sdr.Read())
                {
                    this.txt_Title.Text = sdr["Title"].ToString();

                    if (sdr["PicturePath"].ToString().Length > 0)//
                    {
                        this.img_PicturePath.ImageUrl = sdr["PicturePath"].ToString();
                        this.img_PicturePath.Visible = true;
                    }
                    this.txt_Title.Text = sdr["Phone"].ToString();
                    this.txt_OrderNum.Text = sdr["OrderNum"].ToString();
                    WebControlsFunc.SelectDropDownList(ddls_Type, sdr["Type"].ToString());
                }
            }
            sdr.Close();
        }
    }

    //保存
    protected void btnSave_Click(object sender, EventArgs e)
    {

        string str_PicturePath = this.img_PicturePath.ImageUrl;
        #region 判断类型+保存图片
        if (this.fu_PicturePath != null && this.fu_PicturePath.FileName.Length > 0)
        {
            #region 判断类型
            string[] arrExtension = new string[] { ".gif", ".jpg", ".jpeg", ".bmp", ".png", ".JPG" };
            if (FileFunc.IsAllowedExtension(fu_PicturePath, arrExtension) == false)
            {
                JavaScriptFunc.Alert(this.Page, "图片格式必须是.gif, .jpg, .jpeg, .bmp, .png, .JPG");
                return;
            }
            #endregion
            //赋值
            str_PicturePath = FileFunc.CreateFile(this.Page, fu_PicturePath);
        }
        #endregion
        if (Request["ID"] != null && Request["ID"] != "")
        {
            #region 操作数据库


            StringBuilder strSql = new StringBuilder();
            strSql.Append("update NT_OnlineService set ");
            strSql.Append("Type=@Type,");
            strSql.Append("Title=@Title,");
            strSql.Append("PicturePath=@PicturePath,");
            strSql.Append("Phone=@Phone,");
            strSql.Append("OrderNum=@OrderNum");
            strSql.Append(" where ID=@ID");
            OleDbParameter[] parameters = {
					new OleDbParameter("@Type", OleDbType.VarChar),
					new OleDbParameter("@Title", OleDbType.VarChar),
                    new OleDbParameter("@PicturePath", OleDbType.VarChar),
					new OleDbParameter("@Phone", OleDbType.VarChar),
					new OleDbParameter("@OrderNum", OleDbType.Integer,4),
					new OleDbParameter("@ID", OleDbType.Integer,4)};
            parameters[0].Value = ddls_Type.SelectedValue;
            parameters[1].Value = txt_Title.Text;
            parameters[2].Value = str_PicturePath;
            parameters[3].Value = txt_Phone.Text;
            parameters[4].Value = txt_OrderNum.Text;
            parameters[5].Value = Request["ID"];
            //执行语句
            DbHelperOleDb.ExecuteNonQuery(CommandType.Text, strSql.ToString(), parameters);


            #endregion

            JavaScriptFunc.AlertAndRedirect(this.Page, "修改成功", "OnlineServiceIndex.aspx");
        }
        else
        {
            #region 操作数据库
            StringBuilder strSql1 = new StringBuilder();
            strSql1.Append("select count(*) from NT_OnlineService");
            strSql1.Append(" where Title=@Title");
            OleDbParameter[] parameters1 = {
					new OleDbParameter("@Title", OleDbType.VarChar)};
            parameters1[0].Value = txt_Title.Text;


            object obj = DbHelperOleDb.ExecuteScalar(CommandType.Text, strSql1.ToString(), parameters1);
            if (obj.ToString() != "0")
            {
                JavaScriptFunc.Alert(this.Page, "名称不能重复！");
                return;
            }

            //执行语句

            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into NT_OnlineService(");
            strSql.Append("Type,Title,PicturePath , Phone, OrderNum)");
            strSql.Append(" values (");
            strSql.Append("@Type,@Title, @PicturePath, @Phone ,@OrderNum)");
            OleDbParameter[] parameters = {
					new OleDbParameter("@Type", OleDbType.VarChar),
					new OleDbParameter("@Title", OleDbType.VarChar),
                    new OleDbParameter("@PicturePath", OleDbType.VarChar),
					new OleDbParameter("@Phone", OleDbType.VarChar),
					new OleDbParameter("@OrderNum", OleDbType.Integer)};
            parameters[0].Value = ddls_Type.SelectedValue;
            parameters[1].Value = txt_Title.Text;
            parameters[2].Value = str_PicturePath;
            parameters[3].Value = txt_Phone.Text;
            parameters[4].Value = txt_OrderNum.Text;

            DbHelperOleDb.ExecuteNonQuery(CommandType.Text, strSql.ToString(), parameters);


            #endregion

            JavaScriptFunc.AlertAndRedirect(this.Page, "添加成功", "OnlineServiceIndex.aspx");
        }
    }
}
