﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;
using System.Data;
using System.Data.OleDb;

public partial class BackCenter_Message_MessageEdit : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        #region 过期和权限

        PageFunc.IfLogin(this.Page);
        //PubPageFunc.PageHavePurview(this.Page, "2001");

        #endregion

        if (!IsPostBack)
        {
            #region 页面赋值
            if (Request["ID"] != null)
            {

                StringBuilder strSql = new StringBuilder();
                strSql.Append("select ID,MemberId,Content,AddTime from NT_Message ");
                strSql.Append(" where ID=@ID");
                OleDbParameter[] parameters = { new OleDbParameter("@ID", OleDbType.Integer, 4) };
                parameters[0].Value = Request["ID"];

                OleDbDataReader sdr = DbHelperOleDb.ExecuteDataReader(CommandType.Text, strSql.ToString(), parameters);
                if (sdr.HasRows)
                {
                    while (sdr.Read())
                    {
                        this.txt_Content.Text = sdr["Content"].ToString();
                        this.txt_AddTime.Text = sdr["AddTime"].ToString();
                        this.txt_MemberId.Text = sdr["MemberId"].ToString();
                    }
                }
                sdr.Close();
            }
            #endregion


        }
    }

    //保存
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (Request["ID"] != null && Request["ID"] != "")
        {
            #region 操作数据库


            StringBuilder strSql = new StringBuilder();
            strSql.Append("update NT_Message set ");
            strSql.Append("MemberId=@MemberId,");
            strSql.Append("Content=@Content,");
            strSql.Append("AddTime=@AddTime");
            strSql.Append(" where ID=@ID");
            OleDbParameter[] parameters = {
					new OleDbParameter("@MemberId", OleDbType.Integer,4),
					new OleDbParameter("@Content", OleDbType.VarChar),
					new OleDbParameter("@AddTime", OleDbType.DBDate),
					new OleDbParameter("@ID", OleDbType.Integer,4)};
            parameters[0].Value = txt_MemberId.Text;
            parameters[1].Value = txt_Content.Text;
            parameters[2].Value = txt_AddTime.Text;
            parameters[3].Value = Request["ID"];
            //执行语句
            DbHelperOleDb.ExecuteNonQuery(CommandType.Text, strSql.ToString(), parameters);


            #endregion

            JavaScriptFunc.AlertAndRedirect(this.Page, "修改成功", "MessageIndex.aspx");
        }
        else
        {
            #region 操作数据库


            //执行语句

            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into NT_Message(");
            strSql.Append("MemberId,Content,AddTime)");
            strSql.Append(" values (");
            strSql.Append("@MemberId,@Content,@AddTime)");
            OleDbParameter[] parameters = {
					new OleDbParameter("@MemberId", OleDbType.Integer,4),
					new OleDbParameter("@Content", OleDbType.VarChar),
					new OleDbParameter("@AddTime", OleDbType.DBDate)};
            parameters[0].Value = txt_MemberId.Text;
            parameters[1].Value = txt_Content.Text;
            parameters[2].Value = txt_AddTime.Text;

            DbHelperOleDb.ExecuteNonQuery(CommandType.Text, strSql.ToString(), parameters);


            #endregion

            JavaScriptFunc.AlertAndRedirect(this.Page, "添加成功", "MessageIndex.aspx");
        }
    }
}
