﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;
using System.Data;
using System.Data.OleDb;

public partial class BackCenter_Member_MemberEdit : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        #region 过期和权限

        PageFunc.IfLogin(this.Page);
        //PubPageFunc.PageHavePurview(this.Page, "2001");

        #endregion
        if (!IsPostBack)
        {
            //页面赋值
            PageInit();

        }
    }


    //页面赋值
    protected void PageInit()
    {
        if (Request["ID"] != null)
        {

            StringBuilder strSql = new StringBuilder();
            strSql.Append("select * from NT_Member ");
            strSql.Append(" where ID=@ID");
            OleDbParameter[] parameters = { new OleDbParameter("@ID", OleDbType.Integer, 4) };
            parameters[0].Value = Request["ID"];

            OleDbDataReader sdr = DbHelperOleDb.ExecuteDataReader(CommandType.Text, strSql.ToString(), parameters);
            if (sdr.HasRows)
            {
                while (sdr.Read())
                {
                    this.txt_Account.Text = sdr["Account"].ToString();
                    this.txt_Account.ReadOnly = true;
                    this.txt_Name.Text = sdr["Name"].ToString();
                    if (sdr["Sex"].ToString() == "男")
                    {
                        this.rb_Men.Checked = true;
                    }
                    else
                    {
                        this.rb_Women.Checked = true;
                    }
                    this.ddl_Identity.SelectedValue = sdr["Identity"].ToString();
                    this.txt_Grade.Text = sdr["Grade"].ToString();
                    this.txt_Number.Text = sdr["Number"].ToString();
                    this.txt_Teacher.Text = sdr["Teacher"].ToString();
                    this.txt_Remark.Text = sdr["Remark"].ToString();
                }
            }
            sdr.Close();
        }
    }

    //保存
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (Request["ID"] != null && Request["ID"] != "")
        {
            #region 操作数据库


            StringBuilder strSql = new StringBuilder();
            strSql.Append("update NT_Member set ");
            strSql.Append("[Account]=@Account,");
            strSql.Append("[Name]=@Name,");
            strSql.Append("[Sex]=@Sex,");
            strSql.Append("[Identity]=@Identity,");
            strSql.Append("[Grade]=@Grade,");
            strSql.Append("[Number]=@Number,");
            strSql.Append("[Teacher]=@Teacher");
            strSql.Append("[Remark]=@Remark");
            strSql.Append(" where [ID]=@ID");
            OleDbParameter[] parameters = {
					new OleDbParameter("@Account", OleDbType.VarChar),
                    new OleDbParameter("@Name", OleDbType.VarChar),
					new OleDbParameter("@Sex", OleDbType.VarChar),
                    new OleDbParameter("@Identity", OleDbType.VarChar),
                    new OleDbParameter("@Grade", OleDbType.VarChar),
                    new OleDbParameter("@Number", OleDbType.VarChar),
                    new OleDbParameter("@Teacher", OleDbType.VarChar),
                    new OleDbParameter("@Remark", OleDbType.VarChar),
					new OleDbParameter("@ID", OleDbType.Integer,4)};
            parameters[0].Value = txt_Account.Text.Trim();
            parameters[1].Value = txt_Name.Text.Trim();
            parameters[2].Value = rb_Men.Checked == true ? "男" : "女";
            parameters[3].Value = ddl_Identity.SelectedValue;
            parameters[4].Value = txt_Grade.Text.Trim();
            parameters[5].Value = txt_Number.Text.Trim();
            parameters[6].Value = txt_Teacher.Text.Trim();
            parameters[7].Value = txt_Remark.Text.Trim();
            parameters[8].Value = Request["ID"];
            //执行语句
            DbHelperOleDb.ExecuteNonQuery(CommandType.Text, strSql.ToString(), parameters);


            #endregion

            JavaScriptFunc.AlertAndRedirect(this.Page, "修改成功", "MemberIndex.aspx");
        }
        else
        {
            #region 操作数据库
            StringBuilder strSql1 = new StringBuilder();
            strSql1.Append("select count(*) from NT_Member");
            strSql1.Append(" where Account=@Account");
            OleDbParameter[] parameters1 = {
					new OleDbParameter("@Account", OleDbType.VarChar)};
            parameters1[0].Value = txt_Account.Text;


            object obj = DbHelperOleDb.ExecuteScalar(CommandType.Text, strSql1.ToString(), parameters1);
            if (obj.ToString() != "0")
            {
                JavaScriptFunc.Alert(this.Page, "账号已存在！");
                return;
            }

            //执行语句

            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into NT_Member(");
            strSql.Append("[Account],[Password],[Name],[Sex],[Identity],[Grade],[Number],[Teacher],[Remark])");
            strSql.Append(" values (");
            strSql.Append("@Account,@Password,@Name,@Sex,@Identity,@Grade,@Number,@Teacherr,@Remark)");
            OleDbParameter[] parameters = {
					new OleDbParameter("@Account", OleDbType.VarChar),
					new OleDbParameter("@Password", OleDbType.VarChar),
                    new OleDbParameter("@Name", OleDbType.VarChar),
                    new OleDbParameter("@Sex", OleDbType.VarChar),
                    new OleDbParameter("@Identity", OleDbType.VarChar),
                    new OleDbParameter("@Grade", OleDbType.VarChar),
                    new OleDbParameter("@Number", OleDbType.VarChar),
                    new OleDbParameter("@Teacher", OleDbType.VarChar),
                    new OleDbParameter("@Remark", OleDbType.VarChar)};
            parameters[0].Value = txt_Account.Text.Trim();
            parameters[1].Value = PageFunc.GetMd5("888888");
            parameters[2].Value = txt_Name.Text.Trim();
            parameters[3].Value = rb_Men.Checked == true ? "男" : "女";
            parameters[4].Value = ddl_Identity.SelectedValue;
            parameters[5].Value = txt_Grade.Text.Trim();
            parameters[6].Value = txt_Number.Text.Trim();
            parameters[7].Value = txt_Teacher.Text.Trim();
            parameters[8].Value = txt_Remark.Text.Trim();

            DbHelperOleDb.ExecuteNonQuery(CommandType.Text, strSql.ToString(), parameters);


            #endregion

            JavaScriptFunc.AlertAndRedirect(this.Page, "添加成功,默认密码为：888888", "MemberIndex.aspx");
        }
    }
    
}
