﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class BackCenter_Lab_LabIndex : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {

        #region 过期和权限

        PageFunc.IfLogin(this.Page);
        //PubPageFunc.PageHavePurview(this.Page, "2001");

        #endregion
        if (!IsPostBack)
        {
            BindData();
        }

    }

    //绑定
    public void BindData()
    {

        //计算总数的语句的头部
        string sql_CountFirst = string.Empty;
        sql_CountFirst += " select";
        sql_CountFirst += " count(*)";
        sql_CountFirst += " from NT_Lab l,NT_Member m,NT_Data d  where l.MemberId=m.ID and l.DataId=d.ID  ";

        //查询语句的头部
        string sql_SelectFirst = "select l.ID as lid,l.StartTime,l.EndTime,l.AddTime,l.Audit,m.Account,m.Name,d.Title,d.ID ";
        sql_SelectFirst += " from NT_Lab l,NT_Member m,NT_Data d ";
        sql_SelectFirst += " where l.MemberId=m.ID and l.DataId=d.ID ";

        //排序
        string sql_SelectLast = " order by l.ID desc";


        //查询条件
        string sql_Conditions = string.Empty;

        #region 查询条件

        string str_Title = StringFunc.DataFilter(this.txt_Title.Text.Trim());
        string str_Account = StringFunc.DataFilter(this.txt_Account.Text.Trim());






        if (str_Title.Length > 0)
        {
            sql_Conditions += " and d.Title like '%" + str_Title + "%' ";
        }

        if (str_Account.Length > 0)
        {
            sql_Conditions += " and m.Account like '%" + str_Account + "%' ";
        }

        if (ddl_Audit.SelectedValue != "")
        {
            sql_Conditions += " and l.Audit=" + ddl_Audit.SelectedValue;
        }

        if (txt_Time.Text != "")
        {
            string str_Time = DateTime.Parse(txt_Time.Text).ToShortDateString();
            sql_Conditions += " and (l.StartTime like '" + str_Time + "%' or l.EndTime like '" + str_Time + "%')";
        }


        //判断是否保留分页和查询条件
        string session_Conditions = PageFunc.GetConditions(this.Page);
        sql_Conditions = session_Conditions == "" ? sql_Conditions : session_Conditions;
        ViewState["sql_Conditions"] = sql_Conditions;

        #endregion

        //计算总数的语句
        string str_Count = sql_CountFirst + sql_Conditions;

        //查询语句
        string str_Select = sql_SelectFirst + sql_Conditions + sql_SelectLast;



        WebControlsFunc.BindToAspNetPagerAndGridView(this.Page, GridView1, AspNetPager1, str_Count, str_Select);


    }

    //查询
    protected void btnSearch_Click(object sender, EventArgs e)
    {
        #region 查询-保存查询条件和分页
        Session.Remove("Conditions");
        Session.Remove("PageIndex");
        this.AspNetPager1.CurrentPageIndex = 1;
        #endregion

        BindData();
    }

    //分页
    protected void AspNetPager1_PageChanging(object src, Wuqi.Webdiyer.PageChangingEventArgs e)
    {
        this.AspNetPager1.CurrentPageIndex = e.NewPageIndex;
        BindData();
    }



    //详细
    protected void btnDetails_Command(object sender, CommandEventArgs e)
    {
        JavaScriptFunc.Redirect("LabDetails.aspx?lid=" + e.CommandArgument.ToString());
    }

    //审核
    protected void btnUpdate_Command(object sender, CommandEventArgs e)
    {
        if (e.CommandName == "3")
        {
            JavaScriptFunc.Alert(this.Page, "已取消，无需审核");
            return;
        }
        else if (e.CommandName != "0")
        {
            JavaScriptFunc.Alert(this.Page, "已审核，不能进行重复操作");
            return;
        }
        JavaScriptFunc.Redirect("LabEdit.aspx?lid=" + e.CommandArgument.ToString());
    }

    //取消
    protected void btnCancel_Command(object sender, CommandEventArgs e)
    {
        if (e.CommandName == "3")
        {
            JavaScriptFunc.Alert(this.Page, "已取消，无需在取消");
            return;
        }
        string strSql = "update NT_Lab set Audit=3 where ID=" + e.CommandArgument.ToString();
        DbHelperOleDb.ExecuteNonQuery(CommandType.Text, strSql.ToString(), null);
        JavaScriptFunc.Alert(this.Page, "取消成功");
        BindData();
    }


    //删除
    protected void btnDelete_Command(object sender, CommandEventArgs e)
    {
        string sql = "delete * from NT_Lab where ID=" + e.CommandArgument.ToString();
        DbHelperOleDb.ExecuteNonQuery(CommandType.Text, sql, null);
        BindData();
    }

    //预约状态
    public string GetAudit(string id)
    {
        if (id == "0")
        {
            return "审核中";
        }
        else if (id == "1")
        {
            return "预约成功";
        }
        else if (id == "2")
        {
            return "预约失败";
        }
        else if (id == "3")
        {
            return "已取消";
        }
        return "";

    }
}
