﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;
using System.Data;
using System.Data.OleDb;

public partial class BackCenter_Job_JobEdit : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        #region 过期和权限

        PageFunc.IfLogin(this.Page);
        //PubPageFunc.PageHavePurview(this.Page, "2001");

        #endregion
        if (!IsPostBack)
        {
            //页面赋值
            PageInit();

        }
    }


    //页面赋值
    protected void PageInit()
    {
        if (Request["ID"] != null)
        {

            StringBuilder strSql = new StringBuilder();
            strSql.Append("select [ID],[Title],[Number],[Wage],[Requirements] from NT_Job ");
            strSql.Append(" where ID=@ID");
            OleDbParameter[] parameters = { new OleDbParameter("@ID", OleDbType.Integer, 4) };
            parameters[0].Value = Request["ID"];

            OleDbDataReader sdr = DbHelperOleDb.ExecuteDataReader(CommandType.Text, strSql.ToString(), parameters);
            if (sdr.HasRows)
            {
                while (sdr.Read())
                {
                    this.txt_Title.Text = sdr["Title"].ToString();
                    this.txt_Wage.Text = sdr["Wage"].ToString();
                    this.txt_Number.Text = sdr["Number"].ToString();
                    this.FileContent.Text = sdr["Requirements"].ToString();

                }
            }
            sdr.Close();
        }
    }

    //保存
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (Request["ID"] != null && Request["ID"] != "")
        {
            #region 操作数据库


            StringBuilder strSql = new StringBuilder();
            strSql.Append("update NT_Job set ");
            strSql.Append("[Title]=@Title,");
            strSql.Append("[Wage]=@Wage,");
            strSql.Append("[Number] = @Number,");
            strSql.Append("[Requirements]=@Requirements ");
            strSql.Append(" where [ID]=@ID");
            OleDbParameter[] parameters = {
                    new OleDbParameter("@Title", OleDbType.VarChar),
				     new OleDbParameter("@Wage", OleDbType.VarChar),
                    new OleDbParameter("@Number" , OleDbType.VarChar),
                    new OleDbParameter("@Requirements", OleDbType.VarChar),
					new OleDbParameter("@ID", OleDbType.Integer,4)};
            parameters[0].Value = txt_Title.Text;
            parameters[1].Value = txt_Wage.Text;
            parameters[2].Value = txt_Number.Text;
            parameters[3].Value = FileContent.Text.Trim();
            parameters[4].Value = Request["ID"];
            //执行语句
            DbHelperOleDb.ExecuteNonQuery(CommandType.Text, strSql.ToString(), parameters);


            #endregion

            JavaScriptFunc.AlertAndRedirect(this.Page, "修改成功", "JobIndex.aspx");
        }
        else
        {
            #region 操作数据库
            StringBuilder strSql1 = new StringBuilder();
            strSql1.Append("select count(*) from NT_Job");
            strSql1.Append(" where Title=@Title");
            OleDbParameter[] parameters1 = {
					new OleDbParameter("@Title", OleDbType.VarChar)};
            parameters1[0].Value = txt_Title.Text;


            object obj = DbHelperOleDb.ExecuteScalar(CommandType.Text, strSql1.ToString(), parameters1);
            if (obj.ToString() != "0")
            {
                JavaScriptFunc.Alert(this.Page, "名称不能重复！");
                return;
            }

            //执行语句

            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into NT_Job(");
            strSql.Append("[Title],[Number],[Wage],[Requirements])");
            strSql.Append(" values (");
            strSql.Append("@Title,@Number,@Wage , @Requirements)");
            OleDbParameter[] parameters = {
                    new OleDbParameter("@Title" , OleDbType.VarChar),  
					new OleDbParameter("@Number", OleDbType.VarChar),
					new OleDbParameter("@Wage", OleDbType.VarChar),
					new OleDbParameter("@Requirements", OleDbType.VarChar)};
            parameters[0].Value = txt_Title.Text;
            parameters[1].Value = txt_Number.Text;
            parameters[2].Value = txt_Wage.Text;
            parameters[3].Value = FileContent.Text.Trim();

            DbHelperOleDb.ExecuteNonQuery(CommandType.Text, strSql.ToString(), parameters);


            #endregion

            JavaScriptFunc.AlertAndRedirect(this.Page, "添加成功", "JobIndex.aspx");
        }
    }

}
