﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;
using System.Data;
using System.Data.OleDb;
public partial class BackCenter_Home_Left : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        #region 过期和权限

        PageFunc.IfLogin(this.Page);
        //PubPageFunc.PageHavePurview(this.Page, "2001");

        #endregion

        if (!Page.IsPostBack)
        {
            string sql_SelectFirst = string.Empty;
            if (Session["Account"].ToString() == "admin")
            {
                sql_SelectFirst = "select [Id],[CreateClassId],[ClassType],[ClassName],[ClassPath] ";
                sql_SelectFirst += " from NT_Class ";
                sql_SelectFirst += " where 1=1";
                sql_SelectFirst += " order by OrderNum asc";

            }
            else
            {

                sql_SelectFirst = "SELECT b.[Id],b.[CreateClassId],b.[ClassName],b.[ClassType],b.[ClassPath]";
                sql_SelectFirst += " FROM NT_RoleClass a";
                sql_SelectFirst += " left join NT_Class b on a.ClassId=b.ID";
                sql_SelectFirst += " where RoleId=" + Session["RoleId"] + "";
                sql_SelectFirst += " order by OrderNum asc";

            }
            TreeView1.Nodes.Clear();

            DataSet ds = DbHelperOleDb.ExecuteDataSet(CommandType.Text, sql_SelectFirst, null);
            DataView dv = new DataView(ds.Tables[0]);
            //取根栏目
            dv.RowFilter = "CreateClassId=0";

            foreach (DataRowView drv in dv)
            {
                TreeNode node = new TreeNode();
                node.Text = drv["ClassName"].ToString();
                node.Value = drv["Id"].ToString();

                if (drv["ClassType"].ToString() == "固定数据栏目" || drv["ClassType"].ToString() == "固定功能栏目")
                {
                    node.NavigateUrl = "javascript:;";
                }
                if (drv["ClassType"].ToString() == "数据栏目")
                {
                    node.NavigateUrl = "../Data/DataIndex.aspx?ClassId=" + drv["Id"] + "";

                }
                if (drv["ClassType"].ToString() == "功能栏目")
                {
                    if (drv["ClassPath"].ToString().Length > 0)
                    {
                        node.NavigateUrl = drv["ClassPath"].ToString();
                    }
                    else
                    {
                        node.NavigateUrl = "javascript:;";
                    }
                }
                if (drv["ClassType"].ToString() == "单页栏目")
                {
                    node.NavigateUrl = "../Class/SetSinglePage.aspx?Id=" + drv["Id"] + "";

                }
                node.Target = "mainFrame";
                node.Expanded = false;
                TreeView1.Nodes.Add(node);
                
                //下级节点
                AddChildNode(ds.Tables[0], node);
            }

        }
    }

    #region 递归以实现无限级树
    private void AddChildNode(DataTable dt, TreeNode node)
    {
        DataView dv = new DataView(dt);//建立dt的表视图
        dv.RowFilter = "CreateClassId = " + node.Value + ""; //过滤
        foreach (DataRowView Child_drv in dv)
        {
            TreeNode ChildNode = new TreeNode();
            ChildNode.Text = Child_drv["ClassName"].ToString();
            ChildNode.Value = Child_drv["Id"].ToString();


            if (Child_drv["ClassType"].ToString() == "固定数据栏目" || Child_drv["ClassType"].ToString() == "固定功能栏目")
            {
                ChildNode.NavigateUrl = "javascript:;";
            }

            if (Child_drv["ClassType"].ToString() == "数据栏目")
            {
                ChildNode.NavigateUrl = "../Data/DataIndex.aspx?ClassId=" + Child_drv["Id"] + "";

            }
            if (Child_drv["ClassType"].ToString() == "功能栏目")
            {
                if (Child_drv["ClassPath"].ToString().Length > 0)
                {
                    ChildNode.NavigateUrl = Child_drv["ClassPath"].ToString();
                }
                else
                {
                    ChildNode.NavigateUrl = "javascript:;";
                }
            }
            if (Child_drv["ClassType"].ToString() == "单页栏目")
            {
                ChildNode.NavigateUrl = "../Class/SetSinglePage.aspx?Id=" + Child_drv["Id"] + "";

            }

            ChildNode.Target = "mainFrame";


            ChildNode.Expanded = false;//展开属性为FALSE

            node.ChildNodes.Add(ChildNode);

            AddChildNode(dt, ChildNode);
        }
    }
    #endregion
}
