﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text;
using System.Data;
using System.Data.OleDb;

public partial class BackCenter_Data_DataIndex : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {

        #region 过期和权限

        PageFunc.IfLogin(this.Page);
        //PubPageFunc.PageHavePurview(this.Page, "2001");

        #endregion
        if (!IsPostBack)
        {
            if (Request["ClassId"] != null)
            {
                #region 页面赋值 取栏目信息
                string strSql_Class = "select [ID],[ClassName] from NT_Class where ID=" + Request["ClassId"] + "";
                OleDbDataReader sdr_Class = DbHelperOleDb.ExecuteDataReader(CommandType.Text, strSql_Class, null);
                if (sdr_Class.HasRows)
                {
                    while (sdr_Class.Read())
                    {
                        this.lab_ClassName1.Text = sdr_Class["ClassName"].ToString();
                        this.lab_ClassName2.Text = sdr_Class["ClassName"].ToString();
                    }
                }
                sdr_Class.Close();
                #endregion

                BindData();
            }

        }

    }

    //绑定
    public void BindData()
    {

        //计算总数的语句的头部
        string sql_CountFirst = string.Empty;
        sql_CountFirst += " select";
        sql_CountFirst += " count(*)";
        sql_CountFirst += " from NT_Data a ";
        sql_CountFirst += " left join NT_Class b on a.ClassId=b.Id";
        sql_CountFirst += " where a.ClassId=" + Request["ClassId"] + "";


        //查询语句的头部
        string sql_SelectFirst = "select a.[ID] ,a.[ClassId],a.[Title],a.[AddTime],a.[OrderNum],b.[ClassName] as ClassId_Name  ";
        sql_SelectFirst += " from NT_Data a ";
        sql_SelectFirst += " left join NT_Class b on a.ClassId=b.Id";
        sql_SelectFirst += " where a.ClassId=" + Request["ClassId"] + "";

        if (Request["ClassId"].ToString() == "368") {
            sql_CountFirst += " and ParentId=0";
            sql_SelectFirst += " and ParentId=0";
        }

        //排序
        string sql_SelectLast = " order by a.OrderNum desc, a.Id desc";


        //查询条件
        string sql_Conditions = string.Empty;

        #region 查询条件

        string str_Title = StringFunc.DataFilter(this.txt_Title.Text.Trim());
        if (str_Title.Length > 0)
        {
            sql_Conditions += " and a.Title like '%" + str_Title + "%'";
        }

        //判断是否保留分页和查询条件
        string session_Conditions = PageFunc.GetConditions(this.Page);
        sql_Conditions = session_Conditions == "" ? sql_Conditions : session_Conditions;
        ViewState["sql_Conditions"] = sql_Conditions;
        
        #endregion

        //计算总数的语句
        string str_Count = sql_CountFirst + sql_Conditions;

        //查询语句
        string str_Select = sql_SelectFirst + sql_Conditions + sql_SelectLast;



        //AspNetPager
        //WebControlsFunc.BindToAspNetPager(this.AspNetPager1, CommandType.Text, str_count, null);

        //GridView
        //WebControlsFunc.BindToGridView(this.GridView1, this.AspNetPager1, CommandType.Text, str_select, null);

        WebControlsFunc.BindToAspNetPagerAndGridView(this.Page, GridView1, AspNetPager1, str_Count, str_Select);

        #region 根据不同的系统隐藏没用的功能
        if (Request.QueryString["ClassId"].ToString() == "288")
        {
            GridView1.Columns[5].Visible = true;//评论数
        }
        else
        {
            GridView1.Columns[5].Visible = false;//评论数
        }
        GridView1.Columns[7].Visible = false;//属性
        GridView1.Columns[8].Visible = false;//内容
        GridView1.Columns[9].Visible = false;//图片
        GridView1.Columns[10].Visible = false;//附件
        GridView1.Columns[11].Visible = false;//组合
        #endregion
    }

    //查询
    protected void btnSearch_Click(object sender, EventArgs e)
    {
        #region 查询-保存查询条件和分页
        Session.Remove("Conditions");
        Session.Remove("PageIndex");
        this.AspNetPager1.CurrentPageIndex = 1;
        #endregion

        BindData();
    }

    //分页
    protected void AspNetPager1_PageChanging(object src, Wuqi.Webdiyer.PageChangingEventArgs e)
    {
        this.AspNetPager1.CurrentPageIndex = e.NewPageIndex;
        BindData();
    }

    //转向图片设置页
    protected void btnSetPicture_Command(object sender, CommandEventArgs e)
    {
        #region 保存查询条件和分页
        //分页数
        Session["PageIndex"] = this.AspNetPager1.CurrentPageIndex;
        //查询条件
        Session["Conditions"] = ViewState["sql_Conditions"];
        #endregion

        string url = "SetPicture.aspx?DataId=" + e.CommandArgument.ToString() + "&ClassId=" + e.CommandName.ToString() + "";
        JavaScriptFunc.Redirect(url);
    }
    //转向附件设置页
    protected void btnSetFile_Command(object sender, CommandEventArgs e)
    {
        #region 修改-保存查询条件和分页
        //分页数
        Session["PageIndex"] = this.AspNetPager1.CurrentPageIndex;
        //查询条件
        Session["Conditions"] = ViewState["sql_Conditions"];
        #endregion

        string url = "SetFile.aspx?DataId=" + e.CommandArgument.ToString() + "&ClassId=" + e.CommandName.ToString() + "";
        JavaScriptFunc.Redirect(url);
    }
    //转向组合设置页
    protected void btnSetGroup_Command(object sender, CommandEventArgs e)
    {
        #region 修改-保存查询条件和分页
        //分页数
        Session["PageIndex"] = this.AspNetPager1.CurrentPageIndex;
        //查询条件
        Session["Conditions"] = ViewState["sql_Conditions"];
        #endregion

        string url = "SetGroup.aspx?DataId=" + e.CommandArgument.ToString() + "&ClassId=" + e.CommandName.ToString() + "";
        JavaScriptFunc.Redirect(url);
    }
    //转向属性设置页
    protected void btnSetPropertyValue_Command(object sender, CommandEventArgs e)
    {
        #region 修改-保存查询条件和分页
        //分页数
        Session["PageIndex"] = this.AspNetPager1.CurrentPageIndex;
        //查询条件
        Session["Conditions"] = ViewState["sql_Conditions"];
        #endregion

        string url = "SetPropertyValue.aspx?DataId=" + e.CommandArgument.ToString() + "&ClassId=" + e.CommandName.ToString() + "";
        JavaScriptFunc.Redirect(url);
    }
    //转向属性设置页
    protected void btnSetContent_Command(object sender, CommandEventArgs e)
    {
        #region 修改-保存查询条件和分页
        //分页数
        Session["PageIndex"] = this.AspNetPager1.CurrentPageIndex;
        //查询条件
        Session["Conditions"] = ViewState["sql_Conditions"];
        #endregion

        string url = "SetContent.aspx?DataId=" + e.CommandArgument.ToString() + "&ClassId=" + e.CommandName.ToString() + "";
        JavaScriptFunc.Redirect(url);
    }
    //转向修改页
    protected void btnUpdate_Command(object sender, CommandEventArgs e)
    {
        #region 修改-保存查询条件和分页
        //分页数
        Session["PageIndex"] = this.AspNetPager1.CurrentPageIndex;
        //查询条件
        Session["Conditions"] = ViewState["sql_Conditions"];
        #endregion

        string url = "DataEdit.aspx?Id=" + e.CommandArgument.ToString() + "&ClassId=" + e.CommandName.ToString() + "";
        JavaScriptFunc.Redirect(url);
    }

    //删除
    protected void btnDelete_Command(object sender, CommandEventArgs e)
    {
        string str_ID = e.CommandArgument.ToString();
        string[] sqllist = new string[9];
        sqllist[0] = "delete from NT_Data where Id=" + str_ID + "";
        sqllist[1] = "delete from NT_DataProperty where DataId=" + str_ID + "";
        sqllist[2] = "delete from NT_DataGroup where DataId=" + str_ID + "";
        sqllist[3] = "delete from NT_DataFile where DataId=" + str_ID + "";
        sqllist[4] = "delete from NT_DataPicture where DataId=" + str_ID + "";
        sqllist[5] = "delete from NT_DataContent where DataId=" + str_ID + "";

        //设备预约记录
        sqllist[6] = "delete from NT_Instru where DataId=" + str_ID + "";
        //实验室预约记录
        sqllist[7] = "delete from NT_Lab where DataId=" + str_ID + "";
        //视频评论记录
        sqllist[8] = "delete from NT_Video where DataId=" + str_ID + "";

        DbHelperOleDb.ExecuteSqlTran(sqllist);

        BindData();
    } 
    //转向评论页
    protected void btnVideo_Command(object sender, CommandEventArgs e)
    {
        string url = "../Video/VideoContent.aspx?Id=" + e.CommandArgument.ToString();
        JavaScriptFunc.Redirect(url);
    }


    //统计评论数
    public int GetCount(string id)
    {
        DataSet ds = DbHelperOleDb.ExecuteDataSet(CommandType.Text, "select * from NT_Video where DataId=" + id, null);
        if (ds != null && ds.Tables[0].Rows.Count > 0)
        {
            return ds.Tables[0].Rows.Count;
        }
        else
        {
            return 0;
        }

    }
}
