﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.Text;
using System.Data;
using System.Data.OleDb;

public partial class BackCenter_Class_SetSinglePage : System.Web.UI.Page
{
    //页面加载
    protected void Page_Load(object sender, EventArgs e)
    {
        #region 过期和权限

        PageFunc.IfLogin(this.Page);
        //PubPageFunc.PageHavePurview(this.Page, "2001");

        #endregion

        if (!IsPostBack)
        {

            #region 页面赋值
            if (Request["ID"] != null)
            {


                //页面赋值
                StringBuilder strSql = new StringBuilder();
                strSql.Append("select [ID],[ClassName],[PageTitle],[FilePath],[PageKeyword],[PageDescription],[PagePicture],[PageContent] from NT_Class ");
                strSql.Append(" where ID=@ID");
                OleDbParameter[] parameters = { new OleDbParameter("@ID", OleDbType.Integer, 4) };
                parameters[0].Value = Request["ID"];

                OleDbDataReader sdr = DbHelperOleDb.ExecuteDataReader(CommandType.Text, strSql.ToString(), parameters);
                if (sdr.HasRows)
                {
                    while (sdr.Read())
                    {

                        this.lab_ClassName1.Text = sdr["ClassName"].ToString();
                        this.lab_ClassName2.Text = sdr["ClassName"].ToString();

                        this.txt_PageTitle.Text = sdr["PageTitle"].ToString();
                        this.txt_PageKeyword.Text = sdr["PageKeyword"].ToString();
                        this.txt_PageDescription.Text = sdr["PageDescription"].ToString();

                        if (sdr["PagePicture"].ToString().Length > 0)
                        {
                            this.img_PagePicture.ImageUrl = sdr["PagePicture"].ToString();
                            this.img_PagePicture.Visible = true;
                        }
                        if (sdr["FilePath"].ToString().Length > 0)
                        {
                            this.lab_FilePath.Text = "<a  href='" + sdr["FilePath"].ToString() + "' target='_blank'>下载</a>";
                            //this.img_PicturePath.ImageUrl = sdr["PicturePath"].ToString();
                            //this.img_PicturePath.Visible = true;
                            this.lab_FilePathBak.Text = sdr["FilePath"].ToString();
                        }
                        this.FileContent.Text = sdr["PageContent"].ToString();
                    }
                }
                sdr.Close();
            }
            #endregion
        }

    }

    //保存
    protected void btnSave_Click(object sender, EventArgs e)
    {
        //[ID],[ClassName],[PageTitle],[PageKeyword],[PageDescription],[PagePicture],[PageContent] 

        #region 取控件值
        string str_PageTitle = this.txt_PageTitle.Text;
        string str_PageKeyword = this.txt_PageKeyword.Text;
        string str_PageDescription = this.txt_PageDescription.Text;
        string str_PageContent = this.FileContent.Text;

        string str_PagePicture = this.img_PagePicture.ImageUrl;
        #region 判断类型+保存图片
        if (this.fu_PagePicture != null && this.fu_PagePicture.FileName.Length > 0)
        {
            #region 判断类型
            string[] arrExtension = new string[] { ".gif", ".jpg", ".jpeg", ".bmp", ".png", ".JPG" };
            if (FileFunc.IsAllowedExtension(fu_PagePicture, arrExtension) == false)
            {
                JavaScriptFunc.Alert(this.Page, "图片格式必须是.gif, .jpg, .jpeg, .bmp, .png, .JPG");
                return;
            }
            #endregion
            //赋值
            str_PagePicture = FileFunc.CreateFile(this.Page, fu_PagePicture);
        }
        #endregion
        string str_ID = Request["ID"];

        string str_FilePath = this.lab_FilePathBak.Text;
        #region 附件
        if (this.fu_FilePath != null && this.fu_FilePath.FileName.Length > 0)
        {
            //赋值
            str_FilePath = FileFunc.CreateFile(this.Page, fu_FilePath);
        }
        #endregion
        #endregion

        if (Request["ID"] != null && Request["ID"] != "")
        {
            #region 操作数据库
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update NT_Class set ");
            strSql.Append("PageTitle=@PageTitle,");
            strSql.Append("PageKeyword=@PageKeyword,");
            strSql.Append("PageDescription=@PageDescription,");
            strSql.Append("PageContent=@PageContent,");
            strSql.Append("PagePicture=@PagePicture,");
            strSql.Append("FilePath=@FilePath");
            strSql.Append(" where ID=@ID");
            OleDbParameter[] parameters = {
					new OleDbParameter("@PageTitle", OleDbType.VarChar),
					new OleDbParameter("@PageKeyword", OleDbType.VarChar),
					new OleDbParameter("@PageDescription", OleDbType.VarChar),
                    new OleDbParameter("@PageContent", OleDbType.VarChar),
					new OleDbParameter("@PagePicture", OleDbType.VarChar),
                    new OleDbParameter("@FilePath", OleDbType.VarChar),
					new OleDbParameter("@ID", OleDbType.Integer,4)};
            parameters[0].Value = str_PageTitle;
            parameters[1].Value = str_PageKeyword;
            parameters[2].Value = str_PageDescription;
            parameters[3].Value = str_PageContent;
            parameters[4].Value = str_PagePicture;
            parameters[5].Value = str_FilePath;
            parameters[6].Value = str_ID;

            //执行语句
            DbHelperOleDb.ExecuteNonQuery(CommandType.Text, strSql.ToString(), parameters);


            #endregion

            JavaScriptFunc.AlertAndRedirect(this.Page, "修改成功", "SetSinglePage.aspx?ID=" + str_ID + "");
        }
        
    }
}
