﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.Text;
using System.Data;
using System.Data.OleDb;

public partial class BackCenter_Class_ClassIndex : System.Web.UI.Page
{
    //页面加载
    protected void Page_Load(object sender, EventArgs e)
    {
        #region 过期和权限

        PageFunc.IfLogin(this.Page);
        //PubPageFunc.PageHavePurview(this.Page, "2001");

        #endregion

        if (!IsPostBack)
        {
            //栏目下拉框
            string sql = "select Id,ClassName from NT_Class where ClassType='固定数据栏目' or ClassType='固定功能栏目' order by OrderNum asc,ID desc";
            WebControlsFunc.BindToDropDownList(this.ddl_CreateClassId, sql, "ClassName", "Id", "全部","");
            ListItem item = new ListItem();
            item.Text = "根栏目";
            item.Value = "根栏目";
            ddl_CreateClassId.Items.Insert(1, item);
            BindData();
        }
    }

    //绑定
    public void BindData()
    {

        //计算总数的语句的头部
        string sql_CountFirst = string.Empty;
        sql_CountFirst += " select";
        sql_CountFirst += " count(*)";
        sql_CountFirst += " from NT_Class a";
        sql_CountFirst += " left join NT_Class b on a.CreateClassId=b.Id";
        sql_CountFirst += " where 1=1";


        //查询语句的头部
        string sql_SelectFirst = "select a.[ID],a.[ClassName],a.[ClassType],a.[ClassPicture],a.[OrderNum],b.[ClassName] as CreateClassId_ClassName ";
        sql_SelectFirst += " from NT_Class a";
        sql_SelectFirst += " left join NT_Class b on a.CreateClassId=b.Id";
        sql_SelectFirst += " where 1=1";

        //排序
        string sql_SelectLast = " order by a.OrderNum asc,a.Id desc";


        //查询条件
        string sql_Conditions = string.Empty;

        #region 查询条件

        string str_ClassName = StringFunc.DataFilter(this.txt_ClassName.Text.Trim());
        if (str_ClassName.Length > 0)
        {
            sql_Conditions += " and a.ClassName like '%" + str_ClassName + "%'";
        }
        string str_ClassType = this.ddls_ClassType.SelectedValue;
        if (str_ClassType.Length > 0)
        {
            sql_Conditions += " and a.ClassType ='" + str_ClassType + "'";
        }
        string str_CreateClassId = this.ddl_CreateClassId.SelectedValue;
        if (str_CreateClassId != "根栏目" && str_CreateClassId.Length > 0)
        {
            sql_Conditions += " and a.CreateClassId =" + str_CreateClassId + "";
        }
        if (str_CreateClassId == "根栏目")
        {
            sql_Conditions += " and a.CreateClassId =0";
        }

        //判断是否保留分页和查询条件
        string session_Conditions = PageFunc.GetConditions(this.Page);
        sql_Conditions = session_Conditions == "" ? sql_Conditions : session_Conditions;
        ViewState["sql_Conditions"] = sql_Conditions;

        #endregion



        //计算总数的语句
        string str_Count = sql_CountFirst + sql_Conditions;

        //查询语句
        string str_Select = sql_SelectFirst + sql_Conditions + sql_SelectLast;



        //AspNetPager
        //WebControlsFunc.BindToAspNetPager(this.AspNetPager1, CommandType.Text, str_count, null);

        //GridView
        //WebControlsFunc.BindToGridView(this.GridView1, this.AspNetPager1, CommandType.Text, str_select, null);

        WebControlsFunc.BindToAspNetPagerAndGridView(this.Page, GridView1, AspNetPager1, str_Count, str_Select);
    }

    //查询
    protected void btnSearch_Click(object sender, EventArgs e)
    {
        #region 查询-保存查询条件和分页
        Session.Remove("Conditions");
        Session.Remove("PageIndex");
        this.AspNetPager1.CurrentPageIndex = 1;
        #endregion

        BindData();
    }

    //分页
    protected void AspNetPager1_PageChanging(object src, Wuqi.Webdiyer.PageChangingEventArgs e)
    {
        this.AspNetPager1.CurrentPageIndex = e.NewPageIndex;
        BindData();
    }

    //转向修改页
    protected void btnUpdate_Command(object sender, CommandEventArgs e)
    {
        #region 修改-保存查询条件和分页
        //分页数
        Session["PageIndex"] = this.AspNetPager1.CurrentPageIndex;
        //查询条件
        Session["Conditions"] = ViewState["sql_Conditions"];
        #endregion

        JavaScriptFunc.Redirect("ClassEdit.aspx?Id=" + e.CommandArgument.ToString());
    }

    //转向设置属性名页
    protected void btnSetPropertyName_Command(object sender, CommandEventArgs e)
    {
        #region 修改-保存查询条件和分页
        //分页数
        Session["PageIndex"] = this.AspNetPager1.CurrentPageIndex;
        //查询条件
        Session["Conditions"] = ViewState["sql_Conditions"];
        #endregion

        JavaScriptFunc.Redirect("SetPropertyName.aspx?ClassId=" + e.CommandArgument.ToString());
    }

    //转向设置类别页
    protected void btnSetType_Command(object sender, CommandEventArgs e)
    {
        #region 修改-保存查询条件和分页
        //分页数
        Session["PageIndex"] = this.AspNetPager1.CurrentPageIndex;
        //查询条件
        Session["Conditions"] = ViewState["sql_Conditions"];
        #endregion

        JavaScriptFunc.Redirect("SetType.aspx?ClassId=" + e.CommandArgument.ToString());
    }

    //删除
    protected void btnDelete_Command(object sender, CommandEventArgs e)
    {
        string str_ID = e.CommandArgument.ToString();


        //有数据的栏目不能删除
        string sql1 = "select count(*) from NT_Data where ClassId=" + str_ID + "";
        object obj1 = DbHelperOleDb.ExecuteScalar(CommandType.Text, sql1.ToString(), null);
        //有子栏目的不能删除
        string sql2 = "select count(*) from NT_Class where CreateClassId=" + str_ID + "";
        object obj2 = DbHelperOleDb.ExecuteScalar(CommandType.Text, sql2.ToString(), null);
        if (obj1.ToString() != "0")
        {
            JavaScriptFunc.Alert(this.Page, "该栏目有" + obj1.ToString() + "条数据，不能删除！");
            return;
        }
        if (obj2.ToString() != "0")
        {
            JavaScriptFunc.Alert(this.Page, "该栏目有" + obj2.ToString() + "条子栏目，不能删除！");
            return;

        }
        if (obj1.ToString() == "0" && obj2.ToString() == "0")
        {
            string[] sqllist = new string[2];
            sqllist[0] = "delete from NT_Class where Id=" + str_ID + "";
            sqllist[1] = "delete from NT_ClassProperty where ClassId=" + str_ID + "";
            DbHelperOleDb.ExecuteSqlTran(sqllist);
        }

        BindData();
    }

    //GridView1_RowDataBound
    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        int RowIndex = e.Row.RowIndex;
        if (RowIndex > -1)
        {
            //根据类型显示隐藏设置列
            //if ((e.Row.RowType == DataControlRowType.DataRow) || (e.Row.RowType == DataControlRowType.Header) || (e.Row.RowType == DataControlRowType.Footer))
            if (e.Row.RowType != DataControlRowType.Header)
            {

                if (e.Row.Cells[1].Text.Trim().Length > 0)
                {
                    string str_1 = e.Row.Cells[1].Text.Trim();
                    e.Row.Cells[1].Text = "<img src='" + str_1 + "' width='50px' height='50px' alt='暂无' />";
                }
                else
                {
                    e.Row.Cells[1].Text = "暂无";
                }

                if (e.Row.RowType == DataControlRowType.DataRow && e.Row.Cells[3].Text.Trim() != "数据栏目")
                {
                    e.Row.Cells[6].Enabled = false;
                    e.Row.Cells[6].Text = "";
                }
                if (e.Row.RowType == DataControlRowType.DataRow && e.Row.Cells[3].Text.Trim() != "数据栏目")
                {
                    e.Row.Cells[7].Enabled = false;
                    e.Row.Cells[7].Text = "";
                }
                if (e.Row.RowType == DataControlRowType.DataRow && e.Row.Cells[4].Text.Trim() == "&nbsp;")
                {
                    e.Row.Cells[4].Text = "无";
                }

            }
        }

    } 
}
