﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.Text;
using System.Data;
using System.Data.OleDb;

public partial class BackCenter_Class_ClassEdit : System.Web.UI.Page
{
    //页面加载
    protected void Page_Load(object sender, EventArgs e)
    {
        #region 过期和权限

        PageFunc.IfLogin(this.Page);
        //PubPageFunc.PageHavePurview(this.Page, "2001");

        #endregion

        if (!IsPostBack)
        {
 

            #region 页面赋值
            if (Request["ID"] != null)
            {
                //栏目下拉框
                string sql = "select Id,ClassName from NT_Class where ClassType like '%固定%' and Id<>" + Request["ID"] + " order by OrderNum asc,ID desc";
                WebControlsFunc.BindToDropDownList(this.ddl_CreateClassId, sql, "ClassName", "Id", "根栏目","");


                //页面赋值
                StringBuilder strSql = new StringBuilder();
                strSql.Append("select [ID],[ClassName],[ClassType],[ClassIntro],[ClassPicture],[OrderNum],[CreateClassId],[ClassPath],PageDescription from NT_Class ");
                strSql.Append(" where ID=@ID");
                OleDbParameter[] parameters = { new OleDbParameter("@ID", OleDbType.Integer, 4) };
                parameters[0].Value = Request["ID"];

                OleDbDataReader sdr = DbHelperOleDb.ExecuteDataReader(CommandType.Text, strSql.ToString(), parameters);
                if (sdr.HasRows)
                {
                    while (sdr.Read())
                    {
                        this.txt_ClassName.Text = sdr["ClassName"].ToString();
                        WebControlsFunc.SelectDropDownList(this.ddl_ClassType, sdr["ClassType"].ToString());
                        this.FileContent.Text = sdr["ClassIntro"].ToString();

                        if (sdr["ClassPicture"].ToString().Length > 0)
                        {
                            this.img_ClassPicture.ImageUrl = sdr["ClassPicture"].ToString();
                            this.img_ClassPicture.Visible = true;
                        }
                        ClassDescrption.Text = sdr["PageDescription"].ToString();
                        this.txt_OrderNum.Text = sdr["OrderNum"].ToString();
                        WebControlsFunc.SelectDropDownList(this.ddl_CreateClassId, sdr["CreateClassId"].ToString());

                        this.txt_ClassPath.Text = sdr["ClassPath"].ToString();


                    }
                }
                sdr.Close();
            }

            //添加
            if (Request["ID"] == null)
            {
                //栏目下拉框
                string sql = "select Id,ClassName from NT_Class where ClassType like '%固定%' order by OrderNum asc,ID desc";
                WebControlsFunc.BindToDropDownList(this.ddl_CreateClassId, sql, "ClassName", "Id", "根栏目","");

            }
            #endregion
        }

    }

    //保存
    protected void btnSave_Click(object sender, EventArgs e)
    {
        #region 取控件值
        string str_ClassName = this.txt_ClassName.Text;
        string str_ClassType = this.ddl_ClassType.SelectedValue;
        string str_ClassIntro = FileContent.Text;
        string PageDescription = ClassDescrption.Text;
        string str_ClassPicture = this.img_ClassPicture.ImageUrl;

        #region 判断类型+保存图片
        if (this.fu_ClassPicture != null && this.fu_ClassPicture.FileName.Length > 0)
        {
            #region 判断类型
            string[] arrExtension = new string[] { ".gif", ".jpg", ".jpeg", ".bmp", ".png", ".JPG" };
            if (FileFunc.IsAllowedExtension(fu_ClassPicture, arrExtension) == false)
            {
                JavaScriptFunc.Alert(this.Page, "图片格式必须是.gif, .jpg, .jpeg, .bmp, .png, .JPG");
                return;
            }
            #endregion
            //赋值
            str_ClassPicture = FileFunc.CreateFile(this.Page, fu_ClassPicture);
        }
        #endregion

        string str_OrderNum = this.txt_OrderNum.Text;
        string str_CreateClassId = this.ddl_CreateClassId.SelectedValue;


        string str_ClassPath = this.txt_ClassPath.Text;
        string str_ID = Request["ID"];

        #endregion

        if (Request["ID"] != null && Request["ID"] != "")
        {
            #region 操作数据库


            StringBuilder strSql = new StringBuilder();
            strSql.Append("update NT_Class set ");
            strSql.Append("ClassName=@ClassName,");
            strSql.Append("ClassType=@ClassType,");
            strSql.Append("ClassIntro=@ClassIntro,");
            strSql.Append("ClassPicture=@ClassPicture,");
            strSql.Append("OrderNum=@OrderNum,");
            strSql.Append("CreateClassId=@CreateClassId,");
            strSql.Append("ClassPath=@ClassPath,");
            strSql.Append("PageDescription=@PageDescription");

            strSql.Append(" where ID=@ID");
            OleDbParameter[] parameters = {
					new OleDbParameter("@ClassName", OleDbType.VarChar),
					new OleDbParameter("@ClassType", OleDbType.VarChar),
					new OleDbParameter("@ClassIntro", OleDbType.VarChar),
                    new OleDbParameter("@ClassPicture", OleDbType.VarChar),
					new OleDbParameter("@OrderNum", OleDbType.VarChar),
					new OleDbParameter("@CreateClassId", OleDbType.Integer,4),
                    new OleDbParameter("@ClassPath", OleDbType.VarChar),
                    new OleDbParameter("@PageDescription", OleDbType.VarChar),
					new OleDbParameter("@ID", OleDbType.Integer,4)};
            parameters[0].Value = str_ClassName;
            parameters[1].Value = str_ClassType;
            parameters[2].Value = str_ClassIntro;
            parameters[3].Value = str_ClassPicture;
            parameters[4].Value = str_OrderNum;
            if (str_CreateClassId != "")
            {
                parameters[5].Value = str_CreateClassId;
            }
            else
            {
                parameters[5].Value = "0";
            }
            parameters[6].Value = str_ClassPath;
            parameters[7].Value = PageDescription;
            parameters[8].Value = str_ID;
            //执行语句
            DbHelperOleDb.ExecuteNonQuery(CommandType.Text, strSql.ToString(), parameters);


            #endregion

            JavaScriptFunc.AlertAndRedirect(this.Page, "修改成功", "ClassIndex.aspx?PageIndex=true&Conditions=true");
        }
        else
        {
            #region 操作数据库
            //StringBuilder strSql1 = new StringBuilder();
            //strSql1.Append("select count(*) from NT_Class");
            //strSql1.Append(" where ClassName=@ClassName");
            //OleDbParameter[] parameters1 = {
            //        new OleDbParameter("@ClassName", OleDbType.VarChar)};
            //parameters1[0].Value = txt_ClassName.Text;


            //object obj = DbHelperOleDb.ExecuteScalar(CommandType.Text, strSql1.ToString(), parameters1);
            //if (obj.ToString() != "0")
            //{
            //    JavaScriptFunc.Alert(this.Page, "栏目名称不能重复！");
            //    return;
            //}

            //执行语句

            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into NT_Class(");
            strSql.Append("[ClassName],[ClassType],[ClassIntro],[ClassPicture],[OrderNum],[CreateClassId],[ClassPath])");
            strSql.Append(" values (");
            strSql.Append("@ClassName,@ClassType,@ClassIntro,@ClassPicture,@OrderNum,@CreateClassId,@ClassPath)");
            OleDbParameter[] parameters = {
				new OleDbParameter("@ClassName", OleDbType.VarChar),
					new OleDbParameter("@ClassType", OleDbType.VarChar),
					new OleDbParameter("@ClassIntro", OleDbType.VarChar),
                    new OleDbParameter("@ClassPicture", OleDbType.VarChar),
					new OleDbParameter("@OrderNum", OleDbType.VarChar),
					new OleDbParameter("@CreateClassId", OleDbType.Integer,4),
                     new OleDbParameter("@ClassPath", OleDbType.VarChar),
                    new OleDbParameter("@PageDescription", OleDbType.VarChar)

                                              };
            parameters[0].Value = str_ClassName;
            parameters[1].Value = str_ClassType;
            parameters[2].Value = str_ClassIntro;
            parameters[3].Value = str_ClassPicture;
            parameters[4].Value = str_OrderNum;

            if (str_CreateClassId != "")
            {
                parameters[5].Value = str_CreateClassId;
            }
            else
            {
                parameters[5].Value = "0";
            }

            parameters[6].Value = str_ClassPath;
            parameters[7].Value = PageDescription;




            DbHelperOleDb.ExecuteNonQuery(CommandType.Text, strSql.ToString(), parameters);


            #endregion

            JavaScriptFunc.AlertAndRedirect(this.Page, "添加成功", "ClassIndex.aspx");
        }
    }

}
