﻿using System.Web;
using System.Net.Mail;
using System.Text.RegularExpressions;
using System.Xml;
using System.IO;


/// <summary>
/// Xml的操作类
/// </summary>
public class XmlFunc
{

    #region 通过XML文件节点属性value值找到节点属性text值
    /// <summary>
    /// 通过XML文件节点属性value值找到节点属性text值
    /// </summary>
    /// <param name="XMLpath">XML文件路径</param>
    /// <param name="value">节点属性value值</param>
    /// <returns>节点属性text值</returns>
    public static string getValueByText(string Xmlpath, string value)
    {
        //初始化返回值
        string temp = string.Empty;

        XmlDocument xmlDoc = new XmlDocument();
        xmlDoc.Load(Xmlpath);
        //获取Listitems节点的所有子节点
        XmlNodeList nodeList = xmlDoc.SelectSingleNode("Listitems").ChildNodes;
        //遍历所有子节点 
        foreach (XmlNode xn in nodeList)
        {
            XmlElement xe = (XmlElement)xn;//将子节点类型转换为XmlElement类型
            if (xe.GetAttribute("value") == value)
            {
                return xe.GetAttribute("text");
            }
        }
        return temp;
    }
    #endregion

    #region 通过XML文件节点的属性和节点Name找到节点InnerText
    //Xml格式例子
    //<?xml version="1.0" encoding="gb2312"?>
    //<Websites>
    //  <Website genre="商城首页">
    //    <title>购物网-钱江商城 钱江购物网 5点利品牌购物商城！最安全的网上交易社区，拥有全球时尚前沿的消费者购物集市！</title>
    //    <keywords>手机通讯keywords，电脑整机，数码影音，汽车用品，办公耗材，电脑周边，网络产品，钱江，钱江购物</keywords>
    //    <description>钱江商城 钱江购物网在线销售手机通讯，电脑整机，数码影音，汽车用品，办公耗材，电脑周边，网络产品等，为您提供最新，最全的品种,天天低价、正品保证；全场购物免费送货上门。</description>
    //  </Website>
    //</Websites>
    /// <summary>
    /// 通过XML文件节点的属性和节点Name找到节点InnerText
    /// </summary>
    /// <param name="page">页面</param>
    /// <param name="XMLpath">Xml文件路径</param>
    /// <param name="XmlElementAttribute">节点Attribute属性</param>
    /// <param name="XmlElementName">节点Name</param>
    /// <returns>节点InnerText</returns>
    public static string GetXmlElementInnerText(string Xmlpath, string XmlElementAttribute, string XmlElementName)
    {
        string temp = string.Empty;
        XmlDocument xmlDoc = new XmlDocument();
        xmlDoc.Load(Xmlpath);
        //获取Websites节点的所有子节点
        XmlNodeList nodeList = xmlDoc.SelectSingleNode("Websites").ChildNodes;
        //遍历所有子节点 
        foreach (XmlNode xn in nodeList)
        {
            XmlElement xe = (XmlElement)xn;//将子节点类型转换为XmlElement类型 
            if (xe.GetAttribute("genre") == XmlElementAttribute)//如果genre属性值为“www.cnzz.com” 
            {
                XmlNodeList nls = xe.ChildNodes;//继续获取xe子节点的所有子节点 
                foreach (XmlNode xn1 in nls)//遍历 
                {
                    XmlElement xe2 = (XmlElement)xn1;//转换类型 
                    if (xe2.Name == XmlElementName)//如果找到 
                    {
                        temp = xe2.InnerText;
                    }
                }
            }
        }
        return temp;
    }
    #endregion

    #region 通过XML文件节点的属性和节点Name设置节点InnerText
    //Xml格式例子
    //<?xml version="1.0" encoding="gb2312"?>
    //<Websites>
    //  <Website genre="商城首页">
    //    <title>购物网-钱江商城 钱江购物网 5点利品牌购物商城！最安全的网上交易社区，拥有全球时尚前沿的消费者购物集市！</title>
    //    <keywords>手机通讯keywords，电脑整机，数码影音，汽车用品，办公耗材，电脑周边，网络产品，钱江，钱江购物</keywords>
    //    <description>钱江商城 钱江购物网在线销售手机通讯，电脑整机，数码影音，汽车用品，办公耗材，电脑周边，网络产品等，为您提供最新，最全的品种,天天低价、正品保证；全场购物免费送货上门。</description>
    //  </Website>
    //</Websites>
    /// <summary>
    /// 通过XML文件节点的属性和节点Name设置节点InnerText
    /// </summary>
    /// <param name="page">页面</param>
    /// <param name="XMLpath">Xml文件路径</param>
    /// <param name="XmlElementAttribute">节点Attribute属性</param>
    /// <param name="XmlElementName">节点Name</param>
    /// <param name="XmlElementInnerText">节点InnerText 要设置的值</param>
    /// <returns>bool 是否设置成功</returns>
    public static bool SetXmlElementInnerText(string Xmlpath, string XmlElementAttribute, string XmlElementName, string XmlElementInnerText)
    {
        bool temp = false;
        try
        {
            XmlDocument xmlDoc = new XmlDocument();
            xmlDoc.Load(Xmlpath);
            //获取Websites节点的所有子节点
            XmlNodeList nodeList = xmlDoc.SelectSingleNode("Websites").ChildNodes;
            //遍历所有子节点 
            foreach (XmlNode xn in nodeList)
            {
                XmlElement xe = (XmlElement)xn;//将子节点类型转换为XmlElement类型 
                if (xe.GetAttribute("genre") == XmlElementAttribute)//如果genre属性值为“www.cnzz.com” 
                {
                    XmlNodeList nls = xe.ChildNodes;//继续获取xe子节点的所有子节点 
                    foreach (XmlNode xn1 in nls)//遍历 
                    {
                        XmlElement xe2 = (XmlElement)xn1;//转换类型 
                        if (xe2.Name == XmlElementName)//如果找到 
                        {
                            xe2.InnerText = XmlElementInnerText;
                        }
                    }
                }
            }
            xmlDoc.Save(Xmlpath);//保存
            temp = true;
        }
        catch
        {
            temp = false;
        }
        return temp;
    }
    #endregion
}

