﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.OleDb;
using System.Text;
using System.Xml;




public class WebControlsFunc
{


    #region 操作DropDownList方法

    #region 绑定下拉单DropDownList
    /// <summary>
    /// 绑定下拉单DropDownList
    /// </summary>
    /// <param name="ddl">下拉控件DropDownList</param>
    /// <param name="sql">SQL语句</param>
    /// <param name="text">绑定的Text值</param>
    /// <param name="value">绑定的Value值</param>
    /// <param name="firstitem_name">第一项的Text值</param>
    public static void BindToDropDownList(DropDownList ddl, string sql, string text, string value, string firstitem_name, string firstitem_value)
    {
        ddl.ClearSelection();
        ddl.Items.Clear();

        OleDbDataReader dr = DbHelperOleDb.ExecuteDataReader(CommandType.Text, sql, null);

        ddl.DataSource = dr;
        ddl.DataTextField = text;
        ddl.DataValueField = value;
        ddl.DataBind();

        dr.Close();
        ListItem item = new ListItem();
        item.Text = firstitem_name;
        item.Value = firstitem_value;
        ddl.Items.Insert(0, item);
    }
    #endregion

    #region 根据Value值选择DropDownList项
    /// <summary>
    /// 根据Value值选择DropDownList项
    /// </summary>
    /// <param name="ddl">下拉控件DropDownList</param>
    /// <param name="Value">Value值</param>
    public static void SelectDropDownList(DropDownList ddl, string Value)
    {
        ddl.ClearSelection();
        ListItem li = ddl.Items.FindByValue(Value);
        if (li != null)
        {
            ddl.ClearSelection();
            li.Selected = true;
        }
        else
        {

            ddl.Items[0].Selected = true;
        }
    }
    #endregion

    #region 如果只有一项则不显示DropDownList 因为事先插入了一项“请选择”；一般用于联动显示
    /// <summary>
    /// 如果只有一项则不显示DropDownList 因为事先插入了一项“请选择”；一般用于联动显示
    /// </summary>
    /// <param name="ddl">DropDownList控件</param>
    public static void ShowDropDownList(DropDownList ddl)
    {
        if (ddl.Items.Count > 1)//因为事先插入了一项“请选择XXXX”
        {
            ddl.Visible = true;
        }
        else
        {
            ddl.Visible = false;
        }
    }
    #endregion

    #endregion

    #region 操作RadioButtonList方法

    #region 绑定下拉单RadioButtonList
    /// <summary>
    /// 绑定下拉单RadioButtonList
    /// </summary>
    /// <param name="ddl">下拉控件RadioButtonList</param>
    /// <param name="sql">SQL语句</param>
    /// <param name="text">绑定的Text值</param>
    /// <param name="value">绑定的Value值</param>
    public static void BindToRadioButtonList(RadioButtonList rbl, string sql, string text, string value)
    {
        rbl.ClearSelection();
        rbl.Items.Clear();

        OleDbDataReader dr = DbHelperOleDb.ExecuteDataReader(CommandType.Text, sql, null);

        rbl.DataSource = dr;
        rbl.DataTextField = text;
        rbl.DataValueField = value;
        rbl.DataBind();
        //rbl.Items[0].Selected = true;
        dr.Close();
    }
    #endregion

    #region 根据Value值选择RadioButtonList项
    /// <summary>
    /// 根据Value值选择RadioButtonList项
    /// </summary>
    /// <param name="ddl">下拉控件RadioButtonList</param>
    /// <param name="Value">Value值</param>
    public static void SelectRadioButtonList(RadioButtonList rbl, string Value)
    {
        rbl.ClearSelection();
        ListItem li = rbl.Items.FindByValue(Value);
        if (li != null)
        {
            li.Selected = true;
        }
        else
        {

            rbl.Items[0].Selected = true;
        }
    }
    #endregion

    #endregion

    #region 操作CheckBoxList方法

    #region 绑定下拉单CheckBoxList
    /// <summary>
    /// 绑定下拉单CheckBoxList
    /// </summary>
    /// <param name="ddl">下拉控件CheckBoxList</param>
    /// <param name="sql">SQL语句</param>
    /// <param name="text">绑定的Text值</param>
    /// <param name="value">绑定的Value值</param>
    public static void BindToCheckBoxList(CheckBoxList cbl, string sql, string text, string value)
    {
        cbl.ClearSelection();
        cbl.Items.Clear();

        OleDbDataReader dr = DbHelperOleDb.ExecuteDataReader(CommandType.Text, sql, null);

        cbl.DataSource = dr;
        cbl.DataTextField = text;
        cbl.DataValueField = value;
        cbl.DataBind();

        dr.Close();
    }
    #endregion

    #region 以str参数来返回CheckBoxList的选定项的值组
    /// <summary>
    /// 以str参数来返回CheckBoxList的选定项的值组
    /// </summary>
    /// <param name="cbl">CheckBoxList控件</param>
    /// <param name="str">分隔符</param>
    /// <returns>以str参数组合的字符串</returns>
    public static string GetCheckBoxListValues(CheckBoxList cbl, string str)
    {
        int num = 0;// 选中数初始化
        string temp = string.Empty;
        for (int i = 0; i < cbl.Items.Count; i++)
        {
            if (cbl.Items[i].Selected == true)
            {
                num += 1;
                if (num == 1)
                {
                    temp += cbl.Items[i].Value;
                }
                if (num > 1)
                {
                    temp = temp + str + cbl.Items[i].Value;
                }
            }
        }
        return temp;
    }
    #endregion

    #region 返回CheckBoxList的选中数目
    /// <summary>
    /// 返回CheckBoxList的选中数目
    /// </summary>
    /// <param name="cbl">CheckBoxList控件</param>
    /// <returns>选中数目</returns>
    public static int GetCheckBoxListSelectNum(CheckBoxList cbl)
    {
        int num = 0;// 选中数初始化
        for (int i = 0; i < cbl.Items.Count; i++)
        {
            if (cbl.Items[i].Selected == true)
            {
                num += 1;
            }
        }
        return num;
    }
    #endregion

    #region 根据string[] Value值选择CheckBoxList项
    /// <summary>
    /// 根据string[] Value值选择CheckBoxList项
    /// </summary>
    /// <param name="cbl"></param>
    /// <param name="strs"></param>
    /// <returns></returns>
    public static void SelectCheckBoxList(CheckBoxList cbl, string[] strs)
    {
        for (int i = 0; i < strs.Length; i++)
        {
            //如果复选框中有数组中的项
            if (cbl.Items.FindByValue(strs[i]) != null)
            {
                cbl.Items.FindByValue(strs[i]).Selected = true;
            }
        }
    }
    #endregion

    #endregion

    #region  绑定AspNetPager分页控件
    /// <summary>
    /// 绑定AspNetPager分页控件
    /// </summary>
    /// <param name="AspNetPager1">Wuqi.Webdiyer.AspNetPager AspNetPager</param>
    /// <param name="cmdType">SqlCommand命令类型 (存储过程， T-SQL语句， 等等。)</param>
    /// <param name="cmdText">存储过程的名字或者 T-SQL 语句</param>
    /// <param name="commandParameters">以数组形式提供SqlCommand命令中用到的参数列表</param>
    public static void BindToAspNetPager(Wuqi.Webdiyer.AspNetPager AspNetPager1, CommandType cmdType, string cmdText, params OleDbParameter[] commandParameters)
    {
        //绑定AspNetPager分页控件
        int Total = (int)DbHelperOleDb.ExecuteScalar(cmdType, cmdText, commandParameters);
        AspNetPager1.RecordCount = Total;


    }
    #endregion

    #region 绑定GridView控件
    /// <summary>
    /// 绑定GridView控件
    /// </summary>
    /// <param name="GridView1">GridView</param>
    /// <param name="cmdType">SqlCommand命令类型 (存储过程， T-SQL语句， 等等。)</param>
    /// <param name="cmdText">存储过程的名字或者 T-SQL 语句</param>
    /// <param name="commandParameters">以数组形式提供SqlCommand命令中用到的参数列表</param>
    public static void BindToGridView(GridView GridView1, Wuqi.Webdiyer.AspNetPager AspNetPager1, CommandType cmdType, string cmdText, params OleDbParameter[] commandParameters)
    {
        OleDbDataAdapter sda = DbHelperOleDb.ExecuteDataAdapter(CommandType.Text, cmdText, commandParameters);
        DataSet ds = new DataSet();
        sda.Fill(ds, AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), AspNetPager1.PageSize, "page");//分页绑定
        GridView1.DataSource = ds.Tables["page"];
        GridView1.DataBind();
        GridView1.Dispose();
    }
    #endregion

    #region 绑定DataList控件
    /// <summary>
    /// 绑定DataList控件
    /// </summary>
    /// <param name="DataList1">DataList</param>
    /// <param name="cmdType">SqlCommand命令类型 (存储过程， T-SQL语句， 等等。)</param>
    /// <param name="cmdText">存储过程的名字或者 T-SQL 语句</param>
    /// <param name="commandParameters">以数组形式提供SqlCommand命令中用到的参数列表</param>
    public static void BindToDataList(DataList DataList1, Wuqi.Webdiyer.AspNetPager AspNetPager1, CommandType cmdType, string cmdText, params OleDbParameter[] commandParameters)
    {
        //绑定DataList控件
        OleDbDataAdapter sda = DbHelperOleDb.ExecuteDataAdapter(cmdType, cmdText, commandParameters);
        DataSet ds = new DataSet();
        sda.Fill(ds, AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), AspNetPager1.PageSize, "page");//分页绑定
        DataList1.DataSource = ds.Tables["page"];
        DataList1.DataBind();
        DataList1.Dispose();
    }
    #endregion

    #region AspNetPager分页控件并返回该页的DataTable
    /// <summary>
    /// AspNetPager分页控件并返回该页的DataTable
    /// </summary>
    /// <param name="AspNetPager1">Wuqi.Webdiyer.AspNetPager AspNetPager</param>
    /// <param name="CountSql">总数SQL</param>
    /// <param name="SelectSql">查询SQL</param>
    public static DataTable GetDataTableByAspNetPager(Wuqi.Webdiyer.AspNetPager AspNetPager1, string CountSql, string SelectSql)
    {
        DataTable dt = new DataTable();
        //绑定AspNetPager分页控件
        int Total = (int)DbHelperOleDb.ExecuteScalar(CommandType.Text, CountSql, null);
        AspNetPager1.RecordCount = Total;
        //绑定DataList控件
        OleDbDataAdapter sda = DbHelperOleDb.ExecuteDataAdapter(CommandType.Text, SelectSql, null);
        DataSet ds = new DataSet();
        sda.Fill(ds, AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), AspNetPager1.PageSize, "page");//分页绑定
        if(ds.Tables["page"]!=null)
        {
            dt = ds.Tables["page"];
        }
        return dt;

    }
    #endregion

    #region 一次性绑定AspNetPager分页控件+绑定DataList控件 语句SQL组合作为参数
    /// <summary>
    /// 一次性绑定AspNetPager分页控件+绑定DataList控件 语句SQL组合作为参数
    /// </summary>
    /// <param name="DataList1">DataList</param>
    /// <param name="AspNetPager1">Wuqi.Webdiyer.AspNetPager AspNetPager</param>
    /// <param name="CountSql">总数SQL</param>
    /// <param name="SelectSql">查询SQL</param>
    public static void BindToAspNetPagerAndDataList(DataList DataList1, Wuqi.Webdiyer.AspNetPager AspNetPager1, string CountSql, string SelectSql)
    {
        //绑定AspNetPager分页控件
        int Total = (int)DbHelperOleDb.ExecuteScalar(CommandType.Text, CountSql, null);
        AspNetPager1.RecordCount = Total;
        //绑定DataList控件
        OleDbDataAdapter sda = DbHelperOleDb.ExecuteDataAdapter(CommandType.Text, SelectSql, null);
        DataSet ds = new DataSet();
        sda.Fill(ds, AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), AspNetPager1.PageSize, "page");//分页绑定
        DataList1.DataSource = ds.Tables["page"];
        DataList1.DataBind();
    }
    #endregion

    #region  （保留分页和查询条件版）绑定AspNetPager分页控件+绑定GridView控件 语句SQL组合作为参数
    /// <summary>
    /// （保留分页和查询条件版）绑定AspNetPager分页控件+绑定GridView控件 语句SQL组合作为参数
    /// </summary>
    public static void BindToAspNetPagerAndGridView(Page Page, GridView GridView1, Wuqi.Webdiyer.AspNetPager AspNetPager1, string CountSql, string SelectSql)
    {
        //绑定AspNetPager分页控件
        int Total = (int)DbHelperOleDb.ExecuteScalar(CommandType.Text, CountSql, null);
        AspNetPager1.RecordCount = Total;

        //判断是否保留分页和查询条件
        string PageIndex = PageFunc.GetPageIndex(Page);
        if (PageIndex != "")
        {
            AspNetPager1.CurrentPageIndex = int.Parse(PageIndex);
        }
 
        //绑定GridView控件
        OleDbDataAdapter sda = DbHelperOleDb.ExecuteDataAdapter(CommandType.Text, SelectSql, null);
        DataSet ds = new DataSet();
        sda.Fill(ds, AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), AspNetPager1.PageSize, "page");//分页绑定
        GridView1.DataSource = ds.Tables["page"];
        GridView1.DataBind();


    }
    #endregion

    #region  绑定AspNetPager分页控件+绑定GridView控件 语句SQL组合作为参数
    /// <summary>
    /// 绑定AspNetPager分页控件+绑定GridView控件 语句SQL组合作为参数
    /// </summary>
    public static void BindToAspNetPagerAndGridView(GridView GridView1, Wuqi.Webdiyer.AspNetPager AspNetPager1, string CountSql, string SelectSql)
    {
        //绑定AspNetPager分页控件
        int Total = (int)DbHelperOleDb.ExecuteScalar(CommandType.Text, CountSql, null);
        AspNetPager1.RecordCount = Total;




        //绑定GridView控件
        OleDbDataAdapter sda = DbHelperOleDb.ExecuteDataAdapter(CommandType.Text, SelectSql, null);
        DataSet ds = new DataSet();
        sda.Fill(ds, AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), AspNetPager1.PageSize, "page");//分页绑定
        GridView1.DataSource = ds.Tables["page"];
        GridView1.DataBind();


    }
    #endregion
    #region 一次性绑定AspNetPager分页控件+绑定DataList控件 语句SQL组合作为参数
    /// <summary>
    /// 一次性绑定AspNetPager分页控件+绑定Repeater控件 语句SQL组合作为参数
    /// </summary>
    /// <param name="DataList1">Repeater</param>
    /// <param name="AspNetPager1">Wuqi.Webdiyer.AspNetPager AspNetPager</param>
    /// <param name="CountSql">总数SQL</param>
    /// <param name="SelectSql">查询SQL</param>
    public static void BindToAspNetPagerAndRepeater(Repeater Repeater1, Wuqi.Webdiyer.AspNetPager AspNetPager1, string CountSql, string SelectSql)
    {
        //绑定AspNetPager分页控件
        int Total = (int)DbHelperOleDb.ExecuteScalar(CommandType.Text, CountSql, null);
        AspNetPager1.RecordCount = Total;
        //绑定DataList控件
        OleDbDataAdapter sda = DbHelperOleDb.ExecuteDataAdapter(CommandType.Text, SelectSql, null);
        DataSet ds = new DataSet();
        sda.Fill(ds, AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), AspNetPager1.PageSize, "page");//分页绑定
        Repeater1.DataSource = ds.Tables["page"];
        Repeater1.DataBind();
    }
    #endregion
    #region 返回GridView控件CheckBox的对应的datakey属性值，多个用“,”隔开

    /// <summary>
    /// 返回GridView控件CheckBox的Text属性值，多个用”，“隔开
    /// </summary>
    /// <param name="gv">GridView控件</param>
    /// <param name="ChkName">checkBox控件名</param>
    /// <returns></returns>
    public static string GetGridViewCheckBoxIdsByDataKeys(GridView gv, string ChkName)
    {
        string s = "";
        for (int i = 0; i <= gv.Rows.Count - 1; i++)
        {
            CheckBox Chk = (CheckBox)gv.Rows[i].FindControl(ChkName);
            if (Chk.Checked)
            {
                if (s == "")
                    s = gv.DataKeys[i].Value.ToString();
                else
                    s += "," + gv.DataKeys[i].Value.ToString();
            }
        }
        return s;
    }

    #endregion


}
