﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Security.Cryptography;


public class StringFunc
{
    //防SQL注入数据（开始）
    #region 替换Unicode码+替换关键字(每个传入数据库的值必须调用这个方法)
    /// <summary>
    /// 替换Unicode码+替换关键字（每个传入数据库的值必须调用这个方法）
    /// </summary>
    /// <param name="InputValue">传入值</param>
    public static string DataFilter(string InputValue)
    {
        string temp = string.Empty;
        if (InputValue == null)
        {
            return temp;
        }
        else
        {
            temp = InputValue;
        }
        #region 转换为Unicode码
        string str_a1 = "'|\\|<|>";
        string str_a2 = "&#39;|&#92;|&lt;|&gt;";
        string[] strs_a1 = str_a1.Split('|');
        string[] strs_a2 = str_a2.Split('|');
        //转换
        for (int i = 0; i < strs_a1.Length; i++)
        {
            temp = temp.Replace(strs_a1[i], strs_a2[i]);
        }
        #endregion

        #region 替换SQL关键字
        string word = "and|exec|insert|select|delete|update|chr|mid|master|or|truncate|char|declare|join";
        foreach (string i in word.Split('|'))
        {
            temp = temp.Replace(i + " ", "").Replace(" " + i, "");
        }
        string word1 = "and |exec |insert |select |delete |update |chr |mid |master |or |truncate |char |declare |join ";
        string word2 = " and| exec| insert| select| delete| update| chr| mid| master| or| truncate| char| declare| join";

        temp = Regex.Replace(temp, word1, "", RegexOptions.IgnoreCase);
        temp = Regex.Replace(temp, word2, "", RegexOptions.IgnoreCase);
        #endregion

        return temp;
    }
    #endregion

    #region 编辑显示数据库的值
    /// <summary>
    /// 编辑显示数据库的值
    /// </summary>
    /// <param name="InputValue">值</param>
    public static string DataShow(string InputValue)
    {
        string temp = string.Empty;
        if (InputValue == null)
        {
            return temp;
        }
        else
        {
            temp = InputValue;
        }

        #region 转换Unicode码回原值
        string str1 = "&#39;|&#92;|&lt;|&gt;";
        string str2 = "'|\\|<|>";

        string[] sqlarr1 = str1.Split('|');
        string[] sqlarr2 = str2.Split('|');

        for (int i = 0; i < sqlarr1.Length; i++)
        {
            temp = temp.Replace(sqlarr1[i], sqlarr2[i]);
        }
        #endregion
        return temp;
    }
    #endregion
    //防SQL注入数据（结束）



    #region 过滤编译器里面的特殊标签
    /// <summary>
    /// 过滤编译器里面的特殊标签
    /// </summary>
    public static string ReplaceHtmlFrom(string data)
    {
        return Regex.Replace(data, @"\<form[^>]*>|<\/form>", "", RegexOptions.IgnoreCase);
    }
    #endregion

    #region 删除不可见字符
    /// <summary>
    /// 删除不可见字符
    /// </summary>
    /// <param name="sourceString">源字符串</param>
    /// <returns>已删除后的字符串</returns>
    /// <author>韦忠</author>
    public static string DeleteUnVisibleChar(string sourceString)
    {
        System.Text.StringBuilder sBuilder = new System.Text.StringBuilder(131);
        for (int i = 0; i < sourceString.Length; i++)
        {
            int Unicode = sourceString[i];
            if (Unicode >= 16)
            {
                sBuilder.Append(sourceString[i].ToString());
            }
        }
        return sBuilder.ToString();
    }
    #endregion

    #region 验证字符串格式
    /// <summary>
    /// 验证字符串格式
    /// </summary>
    /// <param name="s">需要验证的字符串</param>
    /// <param name="x">选择正则表达式类型,
    /// 0为验证手机——11位或者12位数字
    /// 1为email,
    /// 2为网址,
    /// 3为中国身份证,
    /// 4为中国电话号码,
    /// 5为验证数字,
    /// 6为验证金钱
    /// 7为验证用户名——由【中文】【a～z】【A～Z】、【0～9】组成（6~18位）
    /// 8为验证密码——由【a～z】【A～Z】、【0～9】组成（6~18位）
    /// 9为验证邮政编码——第一位【1～9】后五位【0～9】
    /// 10位判断地址栏变量 页面传值
    /// 11正整数正则表达式
    /// 12分销商账号 1~18位
    /// </param>
    /// <returns>bool是否匹配</returns>
    /// <author>章军炎</author>
    public static bool CheckDataByRegex(string s, int x)
    {
        string[] regExrArr = 
        { 
            @"^\d{11,12}$",//0.手机验证正则表达式
            @"^([\w-\.]+)@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([\w-]+\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\]?)$",//1.email验证正则表达式
            "http(s)?://([\\w-]+\\.)+[\\w-]+(/[\\w- ./?%&=]*)?", //2.网址验证正则表达式
            @"^\d{17}[\d|X]|\d{15}$",//3.中国公民身份证验证表达式
            @"^((\(\d{2,3}\))|(\d{3}\-))?(\(0\d{2,3}\)|0\d{2,3}-)?[1-9]\d{6,7}(\-\d{1,4})?$",//4.中国电话号码验证表达式，区号+"-"+号码
            "^[-\\+]?\\d+(\\.\\d+)?$",//5.数字验证正则表达式
            "^\\d|\\d+(\\.\\d+)",  //6.金钱验证正则表达式
            @"^[a-zA-Z0-9\u4e00-\u9fa5]{6,18}$", //7.用户名
            @"^[a-zA-Z0-9]{6,18}$", //8.密码
            @"^\d{6}$", //9.邮政编码
            @"^[^']{0,}$" ,//10.判断地址栏变量 页面传值 判断不是‘
            @"^\d{1,10}$",//11.正整数正则表达式
            @"^[a-zA-Z0-9\u4e00-\u9fa5]{1,18}$"//12分销商账号
        };
        string reg = regExrArr[x];
        if (Regex.IsMatch(s, reg))
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    #endregion

    #region 根据最大值最小值判断是否
    /// <summary>
    /// 根据最大值最小值判断是否
    /// </summary>
    /// <param name="StrValue">待转换的字符串</param>
    /// <param name="minLength">最小值-0为不考虑最小值</param>
    /// <param name="maxLength">最大值-int.MaxValue为不考虑最大值</param>
    /// <returns>返回 验证成功true/验证失败false</returns>
    static public bool CheckDataByMaxMin(string StrValue, int minLength, int maxLength)
    {
        bool temp = true;
        if (StrValue != null)//字符串不为null时
        {
            int Length = StrValue.Length;//字符串长度
            if (minLength != 0)
            {
                if (Length < minLength)//如果字符串的长度小于minLength
                {
                    temp = false;
                }
            }
            if (maxLength != int.MaxValue)
            {
                if (Length > maxLength)//如果字符串的长度大于maxLength
                {
                    temp = false;
                }
            }
        }
        else
        {
            temp = false;
        }

        return temp;
    }
    #endregion

    #region 返回截取的字符
    /// <summary>
    /// 返回截取的字符
    /// </summary>
    /// <param name="str">需要截取的字符串</param>
    /// <param name="num">截取的位数</param>
    /// <returns>string</returns>
    /// <author>胡煜</author>
    public static string cutString(string str, int num, string suff)
    {
        int i = str.Length;
        if (i > num)
        {
            return str.Substring(0, num) + suff;
        }
        else
        {
            return str;
        }
    }
    #endregion

    #region 除去所有在HTML元素中标记
    /// <summary>
    /// 除去所有在HTML元素中标记
    /// </summary>
    /// <param name="strHtml">需要过滤的字符串</param>
    /// <returns>过滤后的字符串</returns>
    /// <author>胡煜</author>
    public static string StripHTML(string strHtml)
    {
        string strOutput = strHtml.Trim();
        Regex regex = new Regex(@"<[^>]+>|</[^>]+>");
        Regex reger = new Regex(@"\r");
        Regex regen = new Regex(@"\n");
        Regex regsp = new Regex(@"&nbps");
        strOutput = regex.Replace(strOutput, "");
        strOutput = reger.Replace(strOutput, "");
        strOutput = regen.Replace(strOutput, "");
        strOutput = regsp.Replace(strOutput, "");
        return strOutput;
    }
    #endregion

    #region 根据符号分割字符串
    /// <summary>
    /// 根据符号分割字符串
    /// </summary>
    /// <param name="str"></param>
    /// <returns></returns>
    public static string[] GetStrArray(string str, char cr)
    {
        return str.Split(new char[cr]);
    }
    #endregion

    #region 删除最后一个字符之后的字符
    /// <summary>
    /// 删除最后结尾的指定字符后的字符
    /// </summary>
    public static string DelLastChar(string str, string strchar)
    {
        return str.Substring(0, str.LastIndexOf(strchar));
    }
    #endregion

    #region 转全角的函数(SBC case)
    /// <summary>
    /// 转全角的函数(SBC case)
    /// </summary>
    /// <param name="input"></param>
    /// <returns></returns>
    public static string ToSBC(string input)
    {
        //半角转全角：
        char[] c = input.ToCharArray();
        for (int i = 0; i < c.Length; i++)
        {
            if (c[i] == 32)
            {
                c[i] = (char)12288;
                continue;
            }
            if (c[i] < 127)
                c[i] = (char)(c[i] + 65248);
        }
        return new string(c);
    }
    #endregion

    #region 转半角的函数(SBC case)
    /// <summary>
    ///  转半角的函数(SBC case)
    /// </summary>
    /// <param name="input">输入</param>
    /// <returns></returns>
    public static string ToDBC(string input)
    {
        char[] c = input.ToCharArray();
        for (int i = 0; i < c.Length; i++)
        {
            if (c[i] == 12288)
            {
                c[i] = (char)32;
                continue;
            }
            if (c[i] > 65280 && c[i] < 65375)
                c[i] = (char)(c[i] - 65248);
        }
        return new string(c);
    }
    #endregion

    #region 从字符串里随机得到，规定个数的字符串
    /// <summary>
    /// 从字符串里随机得到，规定个数的字符串.
    /// </summary>
    /// <param name="allChar"></param>
    /// <param name="CodeCount"></param>
    /// <returns></returns>
    private string GetRandomCode(string allChar, int CodeCount)
    {
        //string allChar = "1,2,3,4,5,6,7,8,9,A,B,C,D,E,F,G,H,i,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z"; 
        string[] allCharArray = allChar.Split(',');
        string RandomCode = "";
        int temp = -1;
        Random rand = new Random();
        for (int i = 0; i < CodeCount; i++)
        {
            if (temp != -1)
            {
                rand = new Random(temp * i * ((int)DateTime.Now.Ticks));
            }

            int t = rand.Next(allCharArray.Length - 1);

            while (temp == t)
            {
                t = rand.Next(allCharArray.Length - 1);
            }

            temp = t;
            RandomCode += allCharArray[t];
        }
        return RandomCode;
    }

    #endregion

    #region 从字符串中的删除指定的字符串
    /// <summary>
    /// 从字符串中的删除指定的字符串
    /// </summary>
    /// <param name="sourceString">源字符串</param>
    /// <param name="removedString">要移除的字符串</param>
    /// <returns>移除后的字符串</returns>
    /// <author>韦忠</author>
    public static string Remove(string sourceString, string removedString)
    {
        try
        {
            if (sourceString.IndexOf(removedString) < 0)
                throw new Exception("原字符串中不包含移除字符串！");
            string result = sourceString;
            int lengthOfSourceString = sourceString.Length;
            int lengthOfRemovedString = removedString.Length;
            int startIndex = lengthOfSourceString - lengthOfRemovedString;
            string tempSubString = sourceString.Substring(startIndex);
            if (tempSubString.ToUpper() == removedString.ToUpper())
            {
                result = sourceString.Remove(startIndex, lengthOfRemovedString);
            }
            return result;
        }
        catch
        {
            return sourceString;
        }
    }
    #endregion

    #region 将字符串样式转换为纯字符串
    public static string GetCleanStyle(string StrList, string SplitString)
    {
        string RetrunValue = "";
        //如果为空，返回空值
        if (StrList == null)
        {
            RetrunValue = "";
        }
        else
        {
            //返回去掉分隔符
            string NewString = "";
            NewString = StrList.Replace(SplitString, "");
            RetrunValue = NewString;
        }
        return RetrunValue;
    }
    #endregion

    #region 将字符串转换为新样式
    public static string GetNewStyle(string StrList, string NewStyle, string SplitString, out string Error)
    {
        string ReturnValue = "";
        //如果输入空值，返回空，并给出错误提示
        if (StrList == null)
        {
            ReturnValue = "";
            Error = "请输入需要划分格式的字符串";
        }
        else
        {
            //检查传入的字符串长度和样式是否匹配,如果不匹配，则说明使用错误。给出错误信息并返回空值
            int strListLength = StrList.Length;
            int NewStyleLength = GetCleanStyle(NewStyle, SplitString).Length;
            if (strListLength != NewStyleLength)
            {
                ReturnValue = "";
                Error = "样式格式的长度与输入的字符长度不符，请重新输入";
            }
            else
            {
                //检查新样式中分隔符的位置
                string Lengstr = "";
                for (int i = 0; i < NewStyle.Length; i++)
                {
                    if (NewStyle.Substring(i, 1) == SplitString)
                    {
                        Lengstr = Lengstr + "," + i;
                    }
                }
                if (Lengstr != "")
                {
                    Lengstr = Lengstr.Substring(1);
                }
                //将分隔符放在新样式中的位置
                string[] str = Lengstr.Split(',');
                foreach (string bb in str)
                {
                    StrList = StrList.Insert(int.Parse(bb), SplitString);
                }
                //给出最后的结果
                ReturnValue = StrList;
                //因为是正常的输出，没有错误
                Error = "";
            }
        }
        return ReturnValue;
    }
    #endregion


    //string[]
    #region 分割数组,返回指定索引的数组[renum]
    /// <summary>
    /// 分割数组,返回指定索引的数组[renum]
    /// </summary>
    /// <param name="splitstr">被分割的字符串</param>
    /// <param name="renum">返回分割后的第renum个数组数据</param>
    /// <param name="split">分割的字符</param>
    /// <returns>分割后指定索引的数据</returns>
    public static string SplitString(string splitstr, char split, int renum)
    {
        if (splitstr.Equals(string.Empty))
        {
            return null;
        }
        else
        {
            string[] temp = splitstr.Split(split);
            return temp[renum];
        }
    }
    #endregion

    #region 获取数组元素的合并字符串,如果不想要分隔符，分隔符参数为空即可
    /// <summary>
    /// 获取数组元素的合并字符串,如果不想要分隔符，分隔符参数为空即可
    /// </summary>
    /// <param name="stringArray">源数组对象</param>
    /// <param name="sep">字符串分隔符</param>
    /// <returns>合并后的字符串</returns>
    public static string GetArrayString(string[] stringArray, string sep)
    {
        string totalString = null;
        for (int i = 0; i < stringArray.Length; i++)
        {
            if (i == 0)
            {
                totalString = stringArray[i];
            }
            else
            {
                totalString = totalString + sep + stringArray[i];
            }
        }
        return totalString;
    }

    #endregion

    #region 向数组添加一个值
    public static string[] ArrayAddItem(string[] arr, string item)
    {
        string[] _arr = new string[arr.Length + 1];
        arr.CopyTo(_arr, 0); _arr[arr.Length] = item;
        return _arr;
    }
    public static string[][] ArrayAddItem(string[][] motherArray, string[] arr)
    {
        string[][] _arr = new string[motherArray.Length + 1][];
        motherArray.CopyTo(_arr, 0); _arr[motherArray.Length] = arr; return _arr;
    }
    #endregion

    #region 去除数组中指定的项
    /// <summary>        
    /// 去除数组中指定的项        
    /// </summary>        
    /// <param name="arr">一个字符串数组</param>        
    /// <param name="index">索引项</param>        
    /// <returns></returns>        
    public static string[] RemoveAt(string[] arr, int index)
    {
        if (index >= arr.Length || index < 0)
        { return arr; }
        else
        {
            string[] newArr = new string[arr.Length - 1];
            Array.Copy(arr, 0, newArr, 0, index);
            Array.Copy(arr, index + 1, newArr, index, newArr.Length - index);
            return newArr;
        }
    }
    /// <summary>        
    /// 去除数组中指定的项        
    /// </summary>       
    /// <param name="arr">一个数字数组</param>        
    /// <param name="index">索引项</param>        
    /// <returns></returns>        
    public static int[] RemoveAt(int[] arr, int index)
    {
        if (index >= arr.Length || index < 0)
        { return arr; }
        else
        {
            int[] newArr = new int[arr.Length - 1];
            Array.Copy(arr, 0, newArr, 0, index);
            Array.Copy(arr, index + 1, newArr, index, newArr.Length - index);
            return newArr;
        }
    }
    #endregion

    #region 数组相加
    /// <summary>        
    /// 数组相加        
    /// </summary>        
    /// <param name="arrays">由一维数组组成的二维数组</param>        
    /// <returns></returns>        
    public static string[] arrayAdd(string[][] arrays)
    {
        /*例：             * string[] array1={ };             *string[] array2={"1","2","3"};             *string[] array3={"ab","cd","ef"};             *string[][] arrays={array1,array2,array3};             *string[] newArray=array.arrayAdd(arrays);            */
        int itemsNumber = 0;
        for (int i = 0; i < arrays.Length; i++)
        {
            if (arrays[i] == null)
                continue;
            else
                itemsNumber += arrays[i].Length;
        }
        int endItemNumber = 0;
        string[] newArray = new string[itemsNumber];
        for (int i = 0; i < arrays.Length; i++)
        {
            if (arrays[i] != null)
            {
                arrays[i].CopyTo(newArray, endItemNumber);
                endItemNumber += arrays[i].Length;
            }
        }
        return newArray;
    }
    public static int[] arrayAdd(int[][] arrays)
    {
        int itemsNumber = 0;
        //System.Windows.Forms.MessageBox.Show(arrays.Length + ":走到这里了");            
        for (int i = 0; i < arrays.Length; i++)
        {
            if (arrays[i] == null)
                continue;
            else itemsNumber += arrays[i].Length;
        }
        int endItemNumber = 0;
        int[] newArray = new int[itemsNumber];
        for (int i = 0; i < arrays.Length; i++)
        {
            if (arrays[i] != null)
            {
                arrays[i].CopyTo(newArray, endItemNumber);
                endItemNumber += arrays[i].Length;
            }
        }
        return newArray;
    }
    #endregion

    #region 去除数组内重复的项
    #region 去除数组内重复的项，算法1
    public static string[] RemoveRepeatItem(string[] arr)
    {
        while (arr.Length != _RemoveRepeatItem(arr).Length)
        {
            int size = arr.Length;
            arr = _RemoveRepeatItem(arr);
        } return arr;
    }
    private static string[] _RemoveRepeatItem(string[] arr)
    {            /*             * 下面这种方法以前摘自网上，也可以去除重复，但是如果遇到大量同一个值时，则会出错             * 如  string[] t = { "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm", "htm" };             * 用while循环比较获取的值，直到精简到无重复值             */
        for (int i = 0; i < arr.Length; i++)
        //检查重复内容，如果有重复内容，则将之删除            
        {
            string temStr = arr[i];
            for (int j = i + 1; j < arr.Length; j++)
            {
                if (arr[j] == temStr)
                {
                    arr = RemoveAt(arr, j);
                    //去除当前重复值以后，会对arr重新赋值,而长度也会重新赋值，则永远也走不到arr初始长度的最后                   
                }
            }
        }
        return arr;
    }
    #endregion
    #region 去除数组内重复的项，算法2
    /// <summary>        
    /// 去除数组内重复的项        
    /// </summary>        
    /// <param name="arr"></param>        
    /// <returns></returns>        
    public static string[] RemoveRepeatItems(string[] arr)
    {
        int nullNumber = 0;
        for (int i = 0; i < arr.Length; i++)
        {
            string str = arr[i];
            for (int j = i + 1; j < arr.Length; j++)
            {
                if (str != null && arr[j] == str)
                {
                    arr[j] = null;
                    nullNumber++;
                }
            }
        }
        string[] newArray = new string[arr.Length - nullNumber];
        int n = 0;
        for (int i = 0; i < arr.Length; i++)
        {
            if (arr[i] != null)
            {
                newArray[n] = arr[i];
                n++;
            }
        }
        return newArray;
    }
    #endregion
    #region 移除数组中部分相同的项
    /// <summary>        
    /// 去除数组内部分相同的项。如:"姓名，号码：00000000000,登记时间：2009-12-12","姓名，号码：00000000000,登记时间：2009-21-21",正则表达式用\d{11}，则两项只留一项        
    /// </summary>        
    /// <param name="arr">数组</param>        
    /// <param name="regularText">要检查的正则表达式模式文本</param>        
    /// <returns></returns>        
    public static string[] RemoveRepeatItems(string[] arr, string regularText)
    {
        Regex reg = new Regex(regularText);
        for (int i = 0; i < arr.Length; i++)
        {
            string temStr = arr[i];
            string regText = reg.Match(temStr).Groups[0].Value;
            //arr[i]中符合正则表达式的文本                
            for (int j = 0; j < arr.Length; j++)
            {
                if (j != i && temStr != null)
                {
                    Regex reg1 = new Regex(regularText);
                    string reg1Text = reg1.Match(arr[j]).Groups[0].Value;
                    //arr[j]符合正则表达式的文本                       
                    if (reg1Text == regText)
                        //如果正则表达式匹配文本都相同，则视为重复     
                        arr = RemoveAt(arr, j);
                }
            }
        }
        return arr;
    }
    #endregion
    #region 移除数组中相同的数字项
    /// <summary>        
    /// 去除数组中相同数字的项        
    /// </summary>        
    /// <param name="arr">一个int数组</param>        
    /// <returns></returns>        
    public static int[] RemoveRepeatItems(int[] arr)
    {
        for (int i = 0; i < arr.Length; i++)
        {
            for (int j = i; j < arr.Length; j++)
            {
                if (j != i && arr[j] == arr[i])
                    arr = RemoveAt(arr, j);
            }
        }
        return arr;
    }
    #endregion
    #endregion

    #region 对数组重新排序
    #region 对数字数组进行排列
    /// <summary>        
    /// 对数字进行重新排序        
    /// </summary>        
    /// <param name="arr">一个由数字组成的一维数组</param>        
    /// <param name="MaxToMin">是否按由大到小排列</param>        
    /// <returns></returns>        
    public static int[] ReSequence(int[] arr, bool MaxToMin)
    {
        if (MaxToMin)
            return ReSequence(arr);
        bool flag;
        //设一个标志
        for (int i = 0; i < arr.Length; i++)
        {
            flag = false;
            for (int j = 0; j < arr.Length - 1 - i; j++)
            {
                if (arr[j] > arr[j + 1])
                {
                    int temp = arr[j];
                    arr[j] = arr[j + 1];
                    arr[j + 1] = temp;
                    flag = true;
                    //标志设为true     
                }
            }
            if (flag == false)
                continue;
        } return arr;
    }
    /// <summary>        
    /// 对数组按从大到小的顺序排列        
    /// </summary>        
    /// <param name="arr"></param>        
    /// <returns></returns>        
    private static int[] ReSequence(int[] arr)
    {
        bool flag;
        //设一个标志           
        for (int i = 0; i < arr.Length; i++)
        {
            flag = false;
            for (int j = 0; j < arr.Length - 1 - i; j++)
            {
                if (arr[j] < arr[j + 1])
                {
                    int temp = arr[j];
                    arr[j] = arr[j + 1];
                    arr[j + 1] = temp;
                    flag = true;
                    //标志设为true     
                }
            }
            if (flag == false)
                continue;
        } return arr;
    }
    /// <summary>        
    /// 自己想的排序法。不知道是什么排序法。        
    /// </summary>        
    /// <param name="arr">一个由数字组成的数组</param>        
    /// <param name="t">仅作调用区别，可以是任意字符</param>        
    /// <returns></returns>        
    public static int[] ReSequence(int[] arr, string t)
    {
        for (int i = 0; i < arr.Length; i++)
        {
            for (int j = i; j < arr.Length; j++)
            //遍历数组中的每一项，如果项值大于当前项arr[i]，则互置              
            {
                if (arr[j] > arr[i])
                {
                    int temp = arr[i];
                    arr[i] = arr[j];
                    arr[j] = temp;
                }
            }
        } return arr;
    }
    #endregion
    #region 对包含有数字的字符串数组进行排列
    /// <summary>        
    /// 对包含有数字的字符串数组进行降序排列。如果不包含数字，那么将之排列在最后。如果所包含数字不在int范围内，则出错        
    /// </summary>        
    /// <param name="arr"></param>        
    /// <returns></returns>        
    public static string[] ReSequence(string[] arr)
    {
        string[] tempArr = arr;
        string[] Removes = new string[tempArr.Length];
        //创建一个新数组，用于保存不包含有数字的项。现在假设它的长度和arr相同    
        int RemovesNumber = 0;//不包含有数字的项的长度           
        Regex regForNumber = new Regex("\\d{1,6}");
        for (int i = 0; i < tempArr.Length; i++)
        {
            if (!regForNumber.IsMatch(tempArr[i]))
            //如果当前项中没有检测到数字，则从参数数组中删除，并将值保存到新数组            
            {
                Removes[RemovesNumber] = tempArr[i];
                RemovesNumber++;//如果当前项不包含数字，则RemovesNumber加1   
                tempArr = RemoveAt(tempArr, i);//去除不包含数字的数组        
            }
        }
        //经过上一步操作，tempArr数组中所有的项都包含有数字   
        string[] temRemoves = new string[RemovesNumber];//保存不包含数字的项  
        for (int i = 0; i < temRemoves.Length; i++)//将有效值复制到新的数组    
            temRemoves[i] = Removes[i];
        Removes = temRemoves;//重新设置数组。此时该数组中的项都不包含有符合设定的数字  
        for (int i = 0; i < tempArr.Length; i++)//对包含有数字的数组进行数字排序       
        {
            for (int j = i; j < tempArr.Length; j++)
            //遍历数组中的每一项，如果项值大于当前项arr[i]，则互置  
            {
                int num1 = Convert.ToInt32(regForNumber.Match(tempArr[j]).Groups[0].Value);
                int num2 = Convert.ToInt32(regForNumber.Match(tempArr[i]).Groups[0].Value);
                if (num1 > num2)
                {
                    string temp = tempArr[i];
                    tempArr[i] = tempArr[j];
                    tempArr[j] = temp;
                }
            }
        }
        string[][] arrs = { tempArr, Removes };
        //合并数组            
        return arrayAdd(arrs);
    }
    #endregion
    #endregion

    #region  获取数组内重复最多的项值
    /// <summary>        
    /// 获取数组内重复最多的项值        
    /// </summary>        
    /// <param name="arr">一个字符串数组</param>        
    /// <returns></returns>        
    public static string GetMostItemValue(string[] arr)
    {
        int theMostNumber = 0;
        string value = null;
        for (int i = 0; i < arr.Length; i++)
        {
            int itemNumber = 0;
            string item = arr[i];
            for (int j = i + 1; j < arr.Length; j++)
            {
                string temItem = arr[j];
                if (temItem == item)
                {
                    itemNumber++;
                }
            }
            if (itemNumber > theMostNumber)
            //如果当前项重复数大于原来重复数，视当前数最大    
            {
                theMostNumber = itemNumber;
                value = item;
            }
        }
        return value;
    }
    #endregion

    #region 从字符串数组末尾移除几个数组元素(移除的个数务必小于数组长度)
    /// <summary>
    /// 从字符串数组末尾移除几个数组元素(移除的个数务必小于数组长度)
    /// </summary>
    /// <param name="sourceArray">源数组</param>
    /// <param name="count">要移除的元素个数</param>
    /// <returns>移除元素后的数组</returns>
    public static string[] stringArrayRemove(string[] sourceArray, int count)
    {
        int index = sourceArray.Length;
        if (index < count)
        {
            return sourceArray;
        }
        else
        {
            int newMax = index - count;
            string[] newArray = new string[newMax];
            for (int i = 0; i < newMax; i++)
            {
                newArray[i] = sourceArray[i];
            }
            return newArray;
        }
    }
    #endregion
}

