﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Xml;
using System.IO;
using System.Security.Cryptography;

using System.Drawing;


/// <summary>
/// 页面操作类 登陆过期、地址栏解密等
/// </summary>
public class PageFunc
{

    #region  判断网站后台未登陆或过期
    /// <summary>
    /// 判断网站后台未登陆或过期
    /// </summary>
    /// <param name="page">页面对象</param>
    public static void IfLogin(Page page)
    {
        string url = page.ResolveUrl("~/BackCenter/Home/Login.aspx");
        try
        {
            if (page.Session["Account"] == null)
            {

                JavaScriptFunc.RedirectForTop(url);
            }
        }
        catch
        {
            JavaScriptFunc.RedirectForTop(url);
        }
    }
    #endregion


    #region  判断网站后台未登陆或过期
    /// <summary>
    /// 判断网站后台未登陆或过期
    /// </summary>
    /// <param name="page">页面对象</param>
    public static void IfSystemLogin(Page page)
    {
        string url = page.ResolveUrl("~/index.aspx");
        try
        {
            if (page.Session["Account1"] == null)
            {
                JavaScriptFunc.RedirectForTop(url);
            }
        }
        catch
        {
            JavaScriptFunc.RedirectForTop(url);
        }
    }
    #endregion


    #region 判断该页面是否有权限 判断后直接跳转
    /// <summary>
    /// 判断该页面是否有权限 判断后直接跳转
    /// </summary>
    /// <param name="PurviewIDs">权限数组Session["PurviewIDs"]</param>
    /// <param name="PurviewID">该页面权限值</param>
    /// <returns></returns>
    public static void PageHavePurview(Page page, string PurviewID)
    {
        bool temp = false;
        //不存在Session
        if (page.Session["purviewCodes"] == null)
        {
            temp = false;

        }
        else
        {
            string[] strs_PurviewIDs = page.Session["purviewCodes"].ToString().Split(',');
            for (int i = 0; i < strs_PurviewIDs.Length; i++)
            {
                if (strs_PurviewIDs[i] == PurviewID)
                {
                    temp = true;
                    break;
                }
            }
        }
        if (!temp)
        {
            string url = page.ResolveUrl("~/NewAdmin/Login.aspx");
            JavaScriptFunc.RedirectForTop(url);
        }


    }
    #endregion

    #region  防止重复提交-按钮隐藏一段时间版
    /// <summary>
    /// 点击按钮隐藏一段时间-提交时候防刷新
    /// </summary>
    /// <param name="page">页面</param>
    /// <param name="btn">按钮</param>
    public static void hideButton(Page page, Button btn)
    {
        btn.Attributes.Add("onclick", "state=true;");
        StringBuilder sb = new StringBuilder();
        sb.Append("if (!state) return;");
        sb.Append("var button=document.getElementById('" + btn.ID + "');");
        sb.Append("button.value='Please Wait...';");
        sb.Append("document.body.style.cursor='wait';");
        sb.Append("button.disabled=true;");
        string strScript = "<script>";
        strScript = strScript + "var state=false;";
        //将函数绑定到页面的onbeforeunload事件: 
        strScript = strScript + "window.attachEvent('onbeforeunload',function(){" + sb.ToString() + "});";
        strScript = strScript + "</" + "script>";
        page.ClientScript.RegisterStartupScript(page.GetType(), "onbeforeunload", strScript);
    }
    #endregion

    #region 获取MD5 32位加密(大写)
    /// <summary>
    /// 获取MD5 32位加密(大写)
    /// </summary>
    /// <param name="ConvertString">需要加密的字符串</param>
    /// <returns>返回MD5 32位加密后的字符串 （大写）</returns>
    public static string GetMd5(string ConvertString)
    {
        MD5CryptoServiceProvider md5 = new MD5CryptoServiceProvider();
        string temp = BitConverter.ToString(md5.ComputeHash(UTF8Encoding.Default.GetBytes(ConvertString)));
        temp = temp.Replace("-", "").ToUpper();
        return temp;
    }
    #endregion

    #region 随机生成N位密码
    /// <summary>
    /// 随机生成N位密码
    /// </summary>
    /// <param name="int_length">生成密码的长度</param>
    /// <returns>返回密码字符串</returns>
    public static string RandomValue(int int_length)
    {
        //长度
        //int intLength = 6;
        int intLength = int_length;
        //合法随机显示字符列表
        string strLetters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
        Random r = new Random();
        string back = "";

        for (int i = 0; i < intLength; i++)
        {
            back += strLetters.Substring(r.Next(0, strLetters.Length - 1), 1);
        }

        return back;
    }
    #endregion

    #region DES加密
    /// <summary>
    /// DES加密
    /// </summary>
    /// <param name="pToEncrypt">字符串</param>
    /// <param name="sKey">密钥</param>
    /// <returns>加密后的值</returns>
    private static string Encrypt(string pToEncrypt, string sKey)
    {
        byte[] inputByteArray = Encoding.Default.GetBytes(pToEncrypt);
        //建立加密对象的密钥和偏移量   
        DESCryptoServiceProvider des = new DESCryptoServiceProvider();
        des.Key = ASCIIEncoding.ASCII.GetBytes(sKey);
        des.IV = ASCIIEncoding.ASCII.GetBytes(sKey);
        MemoryStream ms = new MemoryStream();
        CryptoStream cs = new CryptoStream(ms, des.CreateEncryptor(), CryptoStreamMode.Write);
        cs.Write(inputByteArray, 0, inputByteArray.Length);
        cs.FlushFinalBlock();
        StringBuilder ret = new StringBuilder();
        foreach (byte b in ms.ToArray())
        {
            ret.AppendFormat("{0:X2}", b);
        }
        ret.ToString();
        return ret.ToString();
    }
    #endregion

    #region DES解密
    /// <summary>
    /// DES解密
    /// </summary>
    /// <param name="pToDecrypt">字符串</param>
    /// <param name="sKey">密钥</param>
    /// <returns>解密后的值</returns>
    private static string Decrypt(string pToDecrypt, string sKey)
    {
        if (pToDecrypt == "") return "";
        try
        {
            DESCryptoServiceProvider des = new DESCryptoServiceProvider();
            byte[] inputByteArray = new byte[pToDecrypt.Length / 2];
            for (int x = 0; x < pToDecrypt.Length / 2; x++)
            {
                int i = (Convert.ToInt32(pToDecrypt.Substring(x * 2, 2), 16));
                inputByteArray[x] = (byte)i;
            }

            //建立加密对象的密钥和偏移量 
            des.Key = ASCIIEncoding.ASCII.GetBytes(sKey);
            des.IV = ASCIIEncoding.ASCII.GetBytes(sKey);
            MemoryStream ms = new MemoryStream();
            CryptoStream cs = new CryptoStream(ms, des.CreateDecryptor(), CryptoStreamMode.Write);
            cs.Write(inputByteArray, 0, inputByteArray.Length);
            cs.FlushFinalBlock();
            return System.Text.Encoding.Default.GetString(ms.ToArray());

        }
        catch { return ""; }
    }
    #endregion

    #region 专用
    #region 判断是否保留分页和查询条件
    //判断是否查询条件
    /// <summary>
    /// 判断是否查询条件
    /// </summary>
    /// <param name="page"></param>
    /// <returns></returns>
    public static string GetConditions(Page page)
    {
        string temp = "";
        //返回时赋值搜索条件
        if (page.Request["Conditions"] != null && page.Request["Conditions"] == "true")
        {
            if (page.Session["Conditions"] != null)
            {
                try
                {
                    temp = page.Session["Conditions"].ToString();
                    page.Session.Remove("Conditions");
                }
                catch
                {
                    page.Session.Remove("Conditions");
                }
            }
        }
        else
        {
            page.Session.Remove("Conditions");
        }

        return temp;
    }

    //判断是否保留分页
    /// <summary>
    /// 判断是否保留分页
    /// </summary>
    /// <param name="page"></param>
    /// <returns></returns>
    public static string GetPageIndex(Page page)
    {
        string temp = "";
        //返回时赋值搜索条件
        if (page.Request["PageIndex"] != null && page.Request["PageIndex"] == "true")
        {
            if (page.Session["PageIndex"] != null)
            {
                try
                {
                    temp = page.Session["PageIndex"].ToString();
                    page.Session.Remove("PageIndex");
                }
                catch
                {
                    page.Session.Remove("PageIndex");
                }
            }
        }
        else
        {
            page.Session.Remove("PageIndex");
        }

        return temp;
    }
    #endregion
    #endregion

}

