﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text.RegularExpressions;

using System.Text;

/// <summary>
/// JScript 的摘要说明
/// </summary>
public class JavaScriptFunc
{


    #region Alert
    /// <summary>
    /// 弹出信息框
    /// </summary>
    /// <param name="page">当前页面(this)</param>
    /// <param name="msg">所要显示的信息</param>
    public static void Alert(System.Web.UI.Page page, string msg)
    {
        //RegisterStartupScript是指在客户端form结束前添加此代码
        page.ClientScript.RegisterStartupScript(page.GetType(), DateTime.Now.Ticks.ToString(), "alert('" + msg + "');", true);
    }
    #endregion

    #region Redirect
    /// <summary>
    /// 跳转页面
    /// </summary>
    /// <param name="toURL">页面url</param>
    public static void Redirect(string toURL)
    {
        StringBuilder sb = new StringBuilder();
        sb.Append("<script type=\"text/javascript\">" + "\n");
        sb.Append("window.location.href='" + toURL + "';" + "\n");
        sb.Append("</script>" + "\n");
        HttpContext.Current.Response.Write(sb.ToString());
        HttpContext.Current.Response.End();
    }
    #endregion

    #region RedirectForTop
    /// <summary>
    /// 引导到特定页面
    /// </summary>
    /// <param name="page">当前页面(this)</param>
    /// <param name="message">需要弹出的信息内容</param>
    /// <param name="toURL">引导目标页面的全url(http://www.xx.com/)</param>
    public static void RedirectForTop(string toURL)
    {
        StringBuilder sb = new StringBuilder();
        sb.Append("<script type=\"text/javascript\">" + "\n");
        sb.Append("window.top.location.href='" + toURL + "';" + "\n");
        sb.Append("</script>" + "\n");
        HttpContext.Current.Response.Write(sb.ToString());
        HttpContext.Current.Response.End();
    }
    #endregion

    #region AlertAndRedirect
    /// <summary>
    /// 弹出信息框并引导到特定页面
    /// </summary>
    /// <param name="page">当前页面(this)</param>
    /// <param name="message">需要弹出的信息内容</param>
    /// <param name="toURL">引导目标页面的全url(http://www.xx.com/)</param>
    public static void AlertAndRedirect(System.Web.UI.Page page, string message, string toURL)
    {
        StringBuilder sb = new StringBuilder();
        sb.Append("<script type=\"text/javascript\">" + "\n");
        sb.Append("alert('" + message + "');" + "\n");
        sb.Append("window.location.href='" + toURL + "';" + "\n");
        sb.Append("</script>" + "\n");
        HttpContext.Current.Response.Write(sb.ToString());
        HttpContext.Current.Response.End();
    }
    #endregion

    #region AlertAndRedirectForTop
    /// <summary>
    /// 弹出信息框并引导到特定页面
    /// </summary>
    /// <param name="page">当前页面(this)</param>
    /// <param name="message">需要弹出的信息内容</param>
    /// <param name="toURL">引导目标页面的全url(http://www.xx.com/)</param>
    public static void AlertAndRedirectForTop(System.Web.UI.Page page, string message, string toURL)
    {
        string js = "alert('" + message + "');window.top.location='" + toURL + "';";
        page.ClientScript.RegisterStartupScript(page.GetType(), DateTime.Now.Ticks.ToString(), js, true);
    }
    #endregion


    /// <summary>
    /// 显示消息提示对话框
    /// </summary>
    /// <param name="page">当前页面指针，一般为this</param>
    /// <param name="msg">提示信息</param>
    public static void Show(System.Web.UI.Page page, string msg)
    {
        page.ClientScript.RegisterStartupScript(page.GetType(), "message", "<script language='javascript' defer>alert('" + msg.ToString() + "');</script>");
    }

    /// <summary>
    /// 控件点击 消息确认提示框
    /// </summary>
    /// <param name="page">当前页面指针，一般为this</param>
    /// <param name="msg">提示信息</param>
    public static void ShowConfirm(System.Web.UI.WebControls.WebControl Control, string msg)
    {
        //Control.Attributes.Add("onClick","if (!window.confirm('"+msg+"')){return false;}");
        Control.Attributes.Add("onclick", "return confirm('" + msg + "');");
    }

    /// <summary>
    /// 显示消息提示对话框，并进行页面跳转
    /// </summary>
    /// <param name="page">当前页面指针，一般为this</param>
    /// <param name="msg">提示信息</param>
    /// <param name="url">跳转的目标URL</param>
    public static void ShowAndRedirect(System.Web.UI.Page page, string msg, string url)
    {
        //Response.Write("<script>alert('帐户审核通过！现在去为企业充值。');window.location=\"" + pageurl + "\"</script>");
        page.ClientScript.RegisterStartupScript(page.GetType(), "message", "<script language='javascript' defer>alert('" + msg + "');window.location=\"" + url + "\"</script>");


    }
    /// <summary>
    /// 显示消息提示对话框，并进行页面跳转
    /// </summary>
    /// <param name="page">当前页面指针，一般为this</param>
    /// <param name="msg">提示信息</param>
    /// <param name="url">跳转的目标URL</param>
    public static void ShowAndRedirects(System.Web.UI.Page page, string msg, string url)
    {
        StringBuilder Builder = new StringBuilder();
        Builder.Append("<script language='javascript' defer>");
        Builder.AppendFormat("alert('{0}');", msg);
        Builder.AppendFormat("top.location.href='{0}'", url);
        Builder.Append("</script>");
        page.ClientScript.RegisterStartupScript(page.GetType(), "message", Builder.ToString());

    }

    /// <summary>
    /// 输出自定义脚本信息
    /// </summary>
    /// <param name="page">当前页面指针，一般为this</param>
    /// <param name="script">输出脚本</param>
    public static void ResponseScript(System.Web.UI.Page page, string script)
    {
        page.ClientScript.RegisterStartupScript(page.GetType(), "message", "<script language='javascript' defer>" + script + "</script>");

    }


}
