﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Xml;
using System.IO;
using System.Security.Cryptography;

using System.Drawing;


    /// <summary>
    /// 文件IO操作
    /// </summary>
    public class FileFunc
    {

        #region 根据格式数组来判断上传文件类型是否符合需求
        /// <summary>
        /// 根据格式数组来判断上传文件类型是否符合需求
        /// </summary>
        /// <param name="hifile">上传控件</param>
        /// <param name="type">1为图片 2为其他附件</param>
        /// <returns>false表示不匹配格式，true表示匹配格式</returns>
        public static bool IsAllowedExtension(FileUpload hifile, string[] arrExtension)
        {

            bool temp = false;//有限制格式
            string strOldFilePath = "", strExtension = "";
            if (arrExtension != null)
            {
                if (hifile.PostedFile.FileName != string.Empty)
                {
                    strOldFilePath = hifile.PostedFile.FileName;
                    strExtension = strOldFilePath.Substring(strOldFilePath.LastIndexOf("."));
                    for (int i = 0; i < arrExtension.Length; i++)
                    {
                        if (strExtension.Equals(arrExtension[i]))
                        {
                            temp = true;//可以上传
                        }
                    }
                }
            }
            else
            {
                temp = true;//未限定文件格式—可上传任意文件
            }
            return temp;
        }
        #endregion

        #region 上传文件
        /// <summary>
        /// 上传文件返回保存路径
        /// </summary>
        /// <param name="Page"></param>
        /// <param name="hifile"></param>
        /// <returns></returns>
        public static string CreateFile(Page Page,FileUpload hifile)
        {
            //虚拟路径
            string ServerMapPath = Page.Server.MapPath(@"/UploadFiles/BackCenter");
            string SavePath = "/UploadFiles/BackCenter";

            //string ServerMapPath = Page.Server.MapPath(HttpContext.Current.Server.MapPath(System.Configuration.ConfigurationManager.AppSettings["WebPath"]));
            //string SavePath = HttpContext.Current.Server.MapPath(System.Configuration.ConfigurationManager.AppSettings["WebPath"]);

            string tempName = "";
            string FileName = hifile.FileName;
            //取后缀名
            tempName = FileName.Substring(FileName.LastIndexOf('.'), FileName.Length - FileName.LastIndexOf('.'));


            //如果路径不存在，则创建
            if (System.IO.Directory.Exists(ServerMapPath) == false)
            {
                System.IO.Directory.CreateDirectory(ServerMapPath);
            }
            tempName = DateTime.Now.ToString("yyyyMMddHHmmss") + tempName;
            ServerMapPath = ServerMapPath + "/" + tempName;//服务器路径
            SavePath = SavePath + "/" + tempName;//保存路径
            //保存
            hifile.SaveAs(ServerMapPath);
            return SavePath;
        }
        #endregion

        #region 删除文件
        /// <summary>
        /// 删除文件
        /// </summary>
        public static void DeleteFile(Page Page, string filepath)
        {
            string FullPath = Page.Server.MapPath(filepath);

            //全路径=物理路径+数据库存储名
            System.IO.FileInfo file = new System.IO.FileInfo(FullPath);
            if (file.Exists)
            {
                file.Delete();
            }
        }
        #endregion

    }

