﻿using System;
using System.Collections.Generic;
using System.Text;


    public class DateTimeFunc
    {
        #region 把秒转换成分钟
        /// <summary>
        /// 把秒转换成分钟
        /// </summary>
        /// <returns></returns>
        public static int SecondToMinute(int Second)
        {
            decimal mm = (decimal)((decimal)Second / (decimal)60);
            return Convert.ToInt32(Math.Ceiling(mm));
        }
        #endregion

        #region 返回某年某月最后一天
        /// <summary>
        /// 返回某年某月最后一天
        /// </summary>
        /// <param name="year">年份</param>
        /// <param name="month">月份</param>
        /// <returns>日</returns>
        public static int GetMonthLastDate(int year, int month)
        {
            DateTime lastDay = new DateTime(year, month, new System.Globalization.GregorianCalendar().GetDaysInMonth(year, month));
            int Day = lastDay.Day;
            return Day;
        }
        #endregion

        #region 返回时间差
        public static string DateDiff(DateTime DateTime1, DateTime DateTime2)
        {
            string dateDiff = null;
            try
            {
                //TimeSpan ts1 = new TimeSpan(DateTime1.Ticks);
                //TimeSpan ts2 = new TimeSpan(DateTime2.Ticks);
                //TimeSpan ts = ts1.Subtract(ts2).Duration();
                TimeSpan ts = DateTime2 - DateTime1;
                if (ts.Days >=1)
                {
                    dateDiff = DateTime1.Month.ToString() + "月" + DateTime1.Day.ToString() + "日";
                }
                else
                {
                    if (ts.Hours > 1)
                    {
                        dateDiff = ts.Hours.ToString() + "小时前";
                    }
                    else
                    {
                        dateDiff = ts.Minutes.ToString() + "分钟前";
                    }
                }
            }
            catch
            { }
            return dateDiff;
        }
        #endregion

        #region 取日期组合
        /// <summary>
        /// 取日期组合
        /// </summary>
        /// <param name="tm">一个DateTime的时间数据</param>
        /// <param name="tlb">取时间显示类型:１为只取年，２取年月，３取年月日，４取年月日小时，５取年月日小时分钟，６全取到秒，７取月和日，8取时分</param>
        /// <param name="sep">年月日之间的间隔符号</param>
        public static string dateFormat(DateTime tm, int tlb, string sep)
        {
            string year = tm.Year.ToString();
            string month = tm.Month.ToString();
            string day = tm.Day.ToString();
            string hour = tm.Hour.ToString();
            string min = tm.Minute.ToString();
            string sec = tm.Second.ToString();
            string newtime = "";
            if (tlb == 1)
            {
                newtime = year;
            }
            if (tlb == 2)
            {
                newtime = year + sep + month;
            }
            if (tlb == 3)
            {
                newtime = year + sep + month + sep + day;
            }
            if (tlb == 4)
            {
                newtime = year + sep + month + sep + day + " " + hour;
            }
            if (tlb == 5)
            {
                newtime = year + sep + month + sep + day + " " + hour + ":" + min;
            }
            if (tlb == 6)
            {
                newtime = year + sep + month + sep + day + " " + hour + ":" + min + ":" + sec;
            }
            if (tlb == 7)
            {
                newtime = month + sep + day;
            }
            if (tlb == 8)
            {
                newtime = hour + ":" + min;
            }
            if (tlb == 9)
            {
                newtime = month + sep + day + " " + hour + ":" + min;
            }
            return newtime;
        }
        #endregion

        #region 取当前日期
        public static string DateNow()
        {
            DateTime tm = DateTime.Now;
            string year = tm.Year.ToString();
            string month = tm.Month.ToString();
            string day = tm.Day.ToString();
            string newtime = year + "年" + month + "月" + day + "日";
            return newtime;
        }
        #endregion

        #region 取星期几

        public static string WeekDay()
        {
            DayOfWeek d = DateTime.Now.Date.DayOfWeek;
            switch (d)
            {
                case DayOfWeek.Friday:
                    return "星期五";
                    break;
                case DayOfWeek.Monday:
                    return "星期一";
                    break;
                case DayOfWeek.Saturday:
                    return "星期六";
                    break;
                case DayOfWeek.Sunday:
                    return "星期日";
                    break;
                case DayOfWeek.Thursday:
                    return "星期四";
                    break;
                case DayOfWeek.Tuesday:
                    return "星期二";
                    break;
                case DayOfWeek.Wednesday:
                    return "星期三";
                    break;
                default:
                    return "";
                    break;
            }
        }
        #endregion


        public static DateTime AddWorkDays(DateTime dt, int addDays)
        {
            DateTime temp = dt;
            while (addDays-- > 0)
            {
                temp = temp.AddDays(1);
                while (temp.DayOfWeek == DayOfWeek.Saturday || temp.DayOfWeek == DayOfWeek.Sunday)
                    temp = temp.AddDays(1);
            }
            return temp;
        } 
    }

