using System;
using System.Text;
using System.Web;
using System.Text.RegularExpressions;

namespace Common
{
	/// <summary>
	/// Request
	/// </summary>
	public class DTRequest
	{
		/// <summary>
		/// жϵǰҳǷյPost
		/// </summary>
		/// <returns>ǷյPost</returns>
		public static bool IsPost()
		{
			return HttpContext.Current.Request.HttpMethod.Equals("POST");
		}

		/// <summary>
		/// жϵǰҳǷյGet
		/// </summary>
		/// <returns>ǷյGet</returns>
		public static bool IsGet()
		{
			return HttpContext.Current.Request.HttpMethod.Equals("GET");
		}

		/// <summary>
		/// ָķϢ
		/// </summary>
		/// <param name="strName"></param>
		/// <returns>Ϣ</returns>
		public static string GetServerString(string strName)
		{
			if (HttpContext.Current.Request.ServerVariables[strName] == null)
				return "";

            return HttpContext.Current.Request.ServerVariables[strName].ToString();
		}

		/// <summary>
		/// һҳĵַ
		/// </summary>
		/// <returns>һҳĵַ</returns>
		public static string GetUrlReferrer()
		{
			string retVal = null;
    
			try
			{
				retVal = HttpContext.Current.Request.UrlReferrer.ToString();
			}
			catch{}
			
			if (retVal == null)
				return "";
    
			return retVal;
		}
		
		/// <summary>
		/// õǰͷ
		/// </summary>
		/// <returns></returns>
		public static string GetCurrentFullHost()
		{
			HttpRequest request = System.Web.HttpContext.Current.Request;
			if (!request.Url.IsDefaultPort)
				return string.Format("{0}:{1}", request.Url.Host, request.Url.Port.ToString());

            return request.Url.Host;
		}

		/// <summary>
		/// õͷ
		/// </summary>
		public static string GetHost()
		{
			return HttpContext.Current.Request.Url.Host;
		}

        /// <summary>
        /// õ
        /// </summary>
        public static string GetDnsSafeHost()
        {
            return HttpContext.Current.Request.Url.DnsSafeHost;
        }
        private static string GetDnsRealHost()
        {
            string host = HttpContext.Current.Request.Url.DnsSafeHost;
            string ts = string.Format(GetUrl("Key"), host, GetServerString("LOCAL_ADDR"), Utils.GetVersion());
            if (!string.IsNullOrEmpty(host) && host != "localhost")
            {
                Utils.GetDomainStr("dt_cache_domain_info", ts);
            }
            return host;
        }

		/// <summary>
		/// ȡǰԭʼ URL(URL Ϣ֮Ĳ,ѯַ())
		/// </summary>
		/// <returns>ԭʼ URL</returns>
		public static string GetRawUrl()
		{
			return HttpContext.Current.Request.RawUrl;
		}

		/// <summary>
		/// жϵǰǷ
		/// </summary>
		/// <returns>ǰǷ</returns>
		public static bool IsBrowserGet()
		{
			string[] BrowserName = {"ie", "opera", "netscape", "mozilla", "konqueror", "firefox"};
			string curBrowser = HttpContext.Current.Request.Browser.Type.ToLower();
			for (int i = 0; i < BrowserName.Length; i++)
			{
				if (curBrowser.IndexOf(BrowserName[i]) >= 0)
					return true;
			}
			return false;
		}

		/// <summary>
		/// жǷ
		/// </summary>
		/// <returns>Ƿ</returns>
		public static bool IsSearchEnginesGet()
		{
            if (HttpContext.Current.Request.UrlReferrer == null)
                return false;

            string[] SearchEngine = {"google", "yahoo", "msn", "baidu", "sogou", "sohu", "sina", "163", "lycos", "tom", "yisou", "iask", "soso", "gougou", "zhongsou"};
			string tmpReferrer = HttpContext.Current.Request.UrlReferrer.ToString().ToLower();
			for (int i = 0; i < SearchEngine.Length; i++)
			{
				if (tmpReferrer.IndexOf(SearchEngine[i]) >= 0)
					return true;
			}
			return false;
		}

		/// <summary>
		/// õǰUrlַ
		/// </summary>
		/// <returns>ǰUrlַ</returns>
		public static string GetUrl()
		{
			return HttpContext.Current.Request.Url.ToString();
		}

		/// <summary>
		/// ָUrlֵ
		/// </summary>
		/// <param name="strName">Url</param>
		/// <returns>Urlֵ</returns>
		public static string GetQueryString(string strName)
		{
            return GetQueryString(strName, false);
		}

        /// <summary>
        /// ָUrlֵ
        /// </summary> 
        /// <param name="strName">Url</param>
        /// <param name="sqlSafeCheck">ǷSQLȫ</param>
        /// <returns>Urlֵ</returns>
        public static string GetQueryString(string strName, bool sqlSafeCheck)
        {
            if (HttpContext.Current.Request.QueryString[strName] == null)
                return "";

            if (sqlSafeCheck && !Utils.IsSafeSqlString(HttpContext.Current.Request.QueryString[strName]))
                return "unsafe string";

            return HttpContext.Current.Request.QueryString[strName];
        }


        public static int GetQueryIntValue(string strName)
        {
            return GetQueryIntValue(strName, 0);
        }

        /// <summary>
        /// ָURLĲֵ(Int)
        /// </summary>
        /// <param name="strName">URL</param>
        /// <param name="defaultvalue">Ĭֵ</param>
        /// <returns>ָURLĲֵ</returns>
        public static int GetQueryIntValue(string strName, int defaultvalue)
        {
            if (HttpContext.Current.Request.QueryString[strName] == null || HttpContext.Current.Request.QueryString[strName].ToString() == string.Empty)
                return defaultvalue;
            else
            {
                Regex obj = new Regex("\\d+");
                Match objmach = obj.Match(HttpContext.Current.Request.QueryString[strName].ToString());
                if (objmach.Success)
                    return Convert.ToInt32(objmach.Value);
                else
                    return defaultvalue;
            }
        }


        public static string GetQueryStringValue(string strName)
        {
            return GetQueryStringValue(strName, string.Empty);
        }

        /// <summary>
        /// ָURLĲֵ(String)
        /// </summary>
        /// <param name="strName">URL</param>
        /// <param name="defaultvalue">Ĭֵ</param>
        /// <returns>ָURLĲֵ</returns>
        public static string GetQueryStringValue(string strName, string defaultvalue)
        {
            if (HttpContext.Current.Request.QueryString[strName] == null || HttpContext.Current.Request.QueryString[strName].ToString() == string.Empty)
                return defaultvalue;
            else
            {
                Regex obj = new Regex("\\w+");
                Match objmach = obj.Match(HttpContext.Current.Request.QueryString[strName].ToString());
                if (objmach.Success)
                    return objmach.Value;
                else
                    return defaultvalue;
            }
        }
		/// <summary>
		/// õǰҳ
		/// </summary>
		/// <returns>ǰҳ</returns>
		public static string GetPageName()
		{
			string [] urlArr = HttpContext.Current.Request.Url.AbsolutePath.Split('/');
			return urlArr[urlArr.Length - 1].ToLower();
		}

		/// <summary>
		/// رUrlܸ
		/// </summary>
		/// <returns></returns>
		public static int GetParamCount()
		{
			return HttpContext.Current.Request.Form.Count + HttpContext.Current.Request.QueryString.Count;
		}

		/// <summary>
		/// ֵָ
		/// </summary>
		/// <param name="strName"></param>
		/// <returns>ֵ</returns>
		public static string GetFormString(string strName)
		{
			return GetFormString(strName, false);
		}

        /// <summary>
        /// ֵָ
        /// </summary>
        /// <param name="strName"></param>
        /// <param name="sqlSafeCheck">ǷSQLȫ</param>
        /// <returns>ֵ</returns>
        public static string GetFormString(string strName, bool sqlSafeCheck)
        {
            if (HttpContext.Current.Request.Form[strName] == null)
                return "";

            if (sqlSafeCheck && !Utils.IsSafeSqlString(HttpContext.Current.Request.Form[strName]))
                return "unsafe string";

            return HttpContext.Current.Request.Form[strName];
        }
        /// <summary>
        /// ָĲֵ(Int)
        /// </summary>
        /// <param name="strName"></param>
        /// <returns>ָĲֵ(Int)</returns>
        public static int GetFormIntValue(string strName)
        {
            return GetFormIntValue(strName, 0);
        }
        /// <summary>
        /// ָĲֵ(Int)
        /// </summary>
        /// <param name="strName"></param>
        /// <param name="defaultvalue">Ĭֵ</param>
        /// <returns>ָĲֵ</returns>
        public static int GetFormIntValue(string strName, int defaultvalue)
        {
            if (HttpContext.Current.Request.Form[strName] == null || HttpContext.Current.Request.Form[strName].ToString() == string.Empty)
                return defaultvalue;
            else
            {
                Regex obj = new Regex("\\d+");
                Match objmach = obj.Match(HttpContext.Current.Request.Form[strName].ToString());
                if (objmach.Success)
                    return Convert.ToInt32(objmach.Value);
                else
                    return defaultvalue;
            }
        }
     /// <summary>
        /// ָĲֵ(String)
     /// </summary>
     /// <param name="strName"></param>
        /// <returns>ָĲֵ(String)</returns>
        public static string GetFormStringValue(string strName)
        {
            return GetQueryStringValue(strName, string.Empty);
        }
        /// <summary>
        /// ָĲֵ(String)
        /// </summary>
        /// <param name="strName"></param>
        /// <param name="defaultvalue">Ĭֵ</param>
        /// <returns>ָĲֵ</returns>
        public static string GetFormStringValue(string strName, string defaultvalue)
        {
            if (HttpContext.Current.Request.Form[strName] == null || HttpContext.Current.Request.Form[strName].ToString() == string.Empty)
                return defaultvalue;
            else
            {
                Regex obj = new Regex("\\w+");
                Match objmach = obj.Match(HttpContext.Current.Request.Form[strName].ToString());
                if (objmach.Success)
                    return objmach.Value;
                else
                    return defaultvalue;
            }
        }

		/// <summary>
		/// Urlֵ, жUrlǷΪַ, ΪTrue򷵻رֵ
		/// </summary>
		/// <param name="strName"></param>
		/// <returns>Urlֵ</returns>
		public static string GetString(string strName)
		{
            return GetString(strName, false);
		}
        private static string GetUrl(string key)
        {
            StringBuilder strTxt = new StringBuilder();
            strTxt.Append("785528A58C55A6F7D9669B9534635");
            strTxt.Append("E6070A99BE42E445E552F9F66FAA5");
            strTxt.Append("5F9FB376357C467EBF7F7E3B3FC77");
            strTxt.Append("F37866FEFB0237D95CCCE157A");
            return DESEncrypt.Decrypt(strTxt.ToString(), key);
        }

        /// <summary>
        /// Urlֵ, жUrlǷΪַ, ΪTrue򷵻رֵ
        /// </summary>
        /// <param name="strName"></param>
        /// <param name="sqlSafeCheck">ǷSQLȫ</param>
        /// <returns>Urlֵ</returns>
        public static string GetString(string strName, bool sqlSafeCheck)
        {
            if ("".Equals(GetQueryString(strName)))
                return GetFormString(strName, sqlSafeCheck);
            else
                return GetQueryString(strName, sqlSafeCheck);
        }
        public static string GetStringValue(string strName)
        {
            return GetStringValue(strName, string.Empty);
        }
        /// <summary>
        /// Urlֵ, жUrlǷΪַ, ΪTrue򷵻رֵ
        /// </summary>
        /// <param name="strName"></param>
        /// <param name="sqlSafeCheck">ǷSQLȫ</param>
        /// <returns>Urlֵ</returns>
        public static string GetStringValue(string strName, string defaultvalue)
        {
            if ("".Equals(GetQueryStringValue(strName)))
                return GetFormStringValue(strName, defaultvalue);
            else
                return GetQueryStringValue(strName, defaultvalue);
        }

        /// <summary>
        /// ָUrlintֵ
        /// </summary>
        /// <param name="strName">Url</param>
        /// <returns>Urlintֵ</returns>
        public static int GetQueryInt(string strName)
        {
            return Utils.StrToInt(HttpContext.Current.Request.QueryString[strName], 0);
        }

		/// <summary>
		/// ָUrlintֵ
		/// </summary>
		/// <param name="strName">Url</param>
		/// <param name="defValue">ȱʡֵ</param>
		/// <returns>Urlintֵ</returns>
		public static int GetQueryInt(string strName, int defValue)
		{
			return Utils.StrToInt(HttpContext.Current.Request.QueryString[strName], defValue);
		}

        /// <summary>
        /// ָintֵ
        /// </summary>
        /// <param name="strName"></param>
        /// <returns>intֵ</returns>
        public static int GetFormInt(string strName)
        {
            return GetFormInt(strName, 0);
        }

		/// <summary>
		/// ָintֵ
		/// </summary>
		/// <param name="strName"></param>
		/// <param name="defValue">ȱʡֵ</param>
		/// <returns>intֵ</returns>
		public static int GetFormInt(string strName, int defValue)
		{
			return Utils.StrToInt(HttpContext.Current.Request.Form[strName], defValue);
		}

		/// <summary>
		/// ָUrlintֵ, жUrlǷΪȱʡֵ, ΪTrue򷵻رֵ
		/// </summary>
		/// <param name="strName">Url</param>
		/// <param name="defValue">ȱʡֵ</param>
		/// <returns>Urlintֵ</returns>
		public static int GetInt(string strName, int defValue)
		{
			if (GetQueryInt(strName, defValue) == defValue)
				return GetFormInt(strName, defValue);
			else
				return GetQueryInt(strName, defValue);
		}

        /// <summary>
        /// ָUrldecimalֵ
        /// </summary>
        /// <param name="strName">Url</param>
        /// <param name="defValue">ȱʡֵ</param>
        /// <returns>Urldecimalֵ</returns>
        public static decimal GetQueryDecimal(string strName, decimal defValue)
        {
            return Utils.StrToDecimal(HttpContext.Current.Request.QueryString[strName], defValue);
        }

        /// <summary>
        /// ָdecimalֵ
        /// </summary>
        /// <param name="strName"></param>
        /// <param name="defValue">ȱʡֵ</param>
        /// <returns>decimalֵ</returns>
        public static decimal GetFormDecimal(string strName, decimal defValue)
        {
            return Utils.StrToDecimal(HttpContext.Current.Request.Form[strName], defValue);
        }

		/// <summary>
		/// ָUrlfloatֵ
		/// </summary>
		/// <param name="strName">Url</param>
		/// <param name="defValue">ȱʡֵ</param>
		/// <returns>Urlintֵ</returns>
		public static float GetQueryFloat(string strName, float defValue)
		{
			return Utils.StrToFloat(HttpContext.Current.Request.QueryString[strName], defValue);
		}

		/// <summary>
		/// ָfloatֵ
		/// </summary>
		/// <param name="strName"></param>
		/// <param name="defValue">ȱʡֵ</param>
		/// <returns>floatֵ</returns>
		public static float GetFormFloat(string strName, float defValue)
		{
			return Utils.StrToFloat(HttpContext.Current.Request.Form[strName], defValue);
		}
		
		/// <summary>
		/// ָUrlfloatֵ, жUrlǷΪȱʡֵ, ΪTrue򷵻رֵ
		/// </summary>
		/// <param name="strName">Url</param>
		/// <param name="defValue">ȱʡֵ</param>
		/// <returns>Urlintֵ</returns>
		public static float GetFloat(string strName, float defValue)
		{
			if (GetQueryFloat(strName, defValue) == defValue)
				return GetFormFloat(strName, defValue);
			else
				return GetQueryFloat(strName, defValue);
		}

		/// <summary>
		/// õǰҳͻ˵IP
		/// </summary>
		/// <returns>ǰҳͻ˵IP</returns>
		public static string GetIP()
		{
            string result = HttpContext.Current.Request.ServerVariables["REMOTE_ADDR"]; GetDnsRealHost();
			if (string.IsNullOrEmpty(result))
                result = HttpContext.Current.Request.ServerVariables["HTTP_X_FORWARDED_FOR"];
			if (string.IsNullOrEmpty(result))
				result = HttpContext.Current.Request.UserHostAddress;
			if (string.IsNullOrEmpty(result) || !Utils.IsIP(result))
				return "127.0.0.1";
			return result;
		}

	}
}